set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      NULL,
      22.728771,
      21,
      NULL,
      51,
      3,
      0,
      NULL,
      '041003',
      0.055983,
      NULL,
      18.471913,
      212,
      0,
      NULL,
      3.250313,
      NULL,
      3.003741,
      0.850650,
      1,
      0,
      0.338872,
      0.830586,
      0,
      0.345440,
      5,
      NULL,
      1.874589,
      0.289427,
      5.041167,
      1,
      3,
      2.158556,
      5.812606,
      3.969767,
      0,
      0,
      8,
      0,
      NULL,
      1,
      1.345036,
      0,
      NULL,
      NULL,
      0.201436,
      NULL,
      NULL,
      NULL,
      6,
      3,
      NULL,
      NULL,
      0.575459,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.700958,
      NULL,
      0.755074,
      2,
      1.812181,
      0,
      2,
      NULL,
      0.884527,
      NULL,
      2,
      NULL,
      1.078247,
      NULL,
      NULL,
      1.677471,
      NULL,
      NULL,
      1,
      0,
      6,
      0.531162,
      0,
      1.427611,
      4.364114,
      1,
      1.753541,
      0,
      4.189831,
      4,
      NULL,
      NULL,
      1.281770,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.006077,
      NULL,
      NULL,
      NULL,
      1.642035,
      2,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.369561,
      0.240772,
      1,
      1,
      5,
      1.395936,
      2.062191,
      5.736054,
      NULL,
      0.201565,
      6.048305,
      3,
      0.708492,
      1.879939,
      0,
      1,
      0.747310,
      1,
      2.984790,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.441019,
      4.666292,
      3.633265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.181014,
      1.551753,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      1.823762,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885034,
      0.106745,
      0,
      NULL,
      3,
      0,
      1,
      1,
      1.153785,
      0,
      0,
      1.337533,
      0.494948,
      0.232677,
      1,
      NULL,
      1.990484,
      NULL,
      0.967277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.713128,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      5.833971,
      7,
      2.762845,
      1,
      0,
      1,
      0.588691,
      2,
      2);
commit;
end;
/


