set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      '04044040',
      1,
      NULL,
      NULL,
      55.439480,
      2,
      NULL,
      2,
      NULL,
      3,
      ' 5- 4-1980',
      154.958565,
      33,
      NULL,
      NULL,
      3,
      1.304205,
      NULL,
      NULL,
      1.538733,
      2.964423,
      1,
      0,
      1.772393,
      0,
      4.171137,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0.544903,
      NULL,
      0,
      6,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0.176784,
      NULL,
      NULL,
      4,
      NULL,
      4,
      NULL,
      0.439839,
      NULL,
      0.480092,
      1,
      NULL,
      1.839225,
      3,
      1.053263,
      0.492190,
      0.785158,
      3,
      3.140575,
      2,
      2.256756,
      1,
      0.473988,
      NULL,
      0,
      10.136418,
      NULL,
      2,
      0.685845,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.958413,
      0.526229,
      NULL,
      0.143185,
      7,
      6.325412,
      3,
      1.307755,
      0.134795,
      NULL,
      2,
      1.930836,
      1,
      4,
      1.787349,
      0,
      1,
      1,
      1,
      NULL,
      1.678056,
      1.390437,
      3.189436,
      NULL,
      1.767420,
      NULL,
      2,
      1,
      1,
      1.638005,
      1,
      0,
      0.968518,
      NULL,
      NULL,
      0.055080,
      NULL,
      3.659854,
      1.133104,
      3,
      5,
      5,
      NULL,
      NULL,
      7.050694,
      1,
      1.164428,
      NULL,
      3,
      0,
      0.542902,
      1.017456,
      1.348173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.368738,
      1,
      NULL,
      1.409607,
      1.716143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.674350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336843,
      0,
      1,
      2,
      0.389542,
      1.159294,
      1,
      0,
      1.810704,
      0.708913,
      1.875428,
      0,
      1.397548,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '12323',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1.284931,
      '',
      '',
      '',
      NULL,
      0,
      1,
      2.582816,
      3,
      0.701921,
      NULL,
      NULL,
      1);
commit;
end;
/


