set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '033',
      '23230402',
      NULL,
      9.816065,
      NULL,
      8,
      NULL,
      1,
      0,
      '141100',
      1,
      ' 9- 4-1989',
      NULL,
      162,
      0.769981,
      NULL,
      3,
      NULL,
      1,
      0.463597,
      NULL,
      1,
      0,
      0,
      NULL,
      1.298743,
      NULL,
      1.813519,
      NULL,
      5.871972,
      1,
      1,
      NULL,
      0.602229,
      1.969695,
      1,
      1,
      0,
      3.376780,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.195506,
      NULL,
      NULL,
      NULL,
      0.073673,
      5.843186,
      3,
      1,
      0,
      1.890149,
      1.540332,
      1,
      NULL,
      NULL,
      0.822915,
      0,
      1,
      3.850246,
      2.798290,
      0,
      0.348946,
      1.694125,
      0.630326,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312422,
      7,
      7.649331,
      NULL,
      1,
      1,
      2.791801,
      2.413822,
      2.135532,
      1.549852,
      4.628452,
      0.774537,
      0.850806,
      NULL,
      0.017198,
      0,
      NULL,
      1.344330,
      NULL,
      5.778776,
      0.251300,
      0.894067,
      4,
      0,
      1.442892,
      0,
      1.594476,
      1,
      1,
      0.011652,
      1.722306,
      NULL,
      1,
      1,
      1,
      0.672499,
      4,
      1,
      7.144946,
      0,
      3,
      6,
      0.355530,
      1.920941,
      1,
      0,
      1,
      0.474804,
      0.888192,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.365187,
      1.624451,
      1.195534,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149861,
      NULL,
      4,
      NULL,
      0.249738,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389909,
      2.821738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687417,
      0.293302,
      3,
      NULL,
      0.990392,
      3.936963,
      3.992950,
      0.725619,
      1.737337,
      1.389100,
      1.788808,
      NULL,
      1,
      0.212086,
      NULL,
      1.325525,
      1.164837,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '21002',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      4.826674,
      1,
      1,
      0.224240,
      0,
      1,
      0,
      1.142534,
      NULL);
commit;
end;
/


