set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '333',
      NULL,
      74,
      22.233184,
      NULL,
      20,
      1,
      2.490711,
      1,
      '201041',
      NULL,
      '10- 0-1990',
      81.098476,
      8,
      NULL,
      NULL,
      3.062739,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.616037,
      1.501826,
      NULL,
      11.446528,
      1.620310,
      1,
      1,
      NULL,
      0.333092,
      9.955275,
      NULL,
      0.566290,
      1.593376,
      0.765604,
      1,
      NULL,
      1,
      5,
      NULL,
      1.467908,
      0.737663,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.804881,
      1,
      2.138709,
      NULL,
      1.953251,
      0.639087,
      0,
      1,
      1,
      2,
      2.759512,
      NULL,
      NULL,
      0,
      1.762717,
      1,
      3,
      0.053800,
      0.894795,
      0.518890,
      0,
      1.373532,
      9.611143,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0.460666,
      NULL,
      NULL,
      NULL,
      7.836277,
      8.502029,
      NULL,
      0.773450,
      3,
      1.180193,
      NULL,
      NULL,
      NULL,
      1.752465,
      3,
      0.115150,
      1.029350,
      NULL,
      1,
      1,
      1.470382,
      1.005269,
      NULL,
      NULL,
      1.243976,
      4,
      NULL,
      0,
      4.874512,
      3.989312,
      NULL,
      0.072940,
      1,
      0,
      0.360341,
      1,
      1.250681,
      NULL,
      1,
      1.311647,
      0,
      3,
      1.122861,
      NULL,
      2.074816,
      2,
      NULL,
      6,
      0.240405,
      0.116329,
      1.527850,
      3.822978,
      1.961356,
      0,
      3.117784,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.395057,
      NULL,
      2.895446,
      NULL,
      1.609715,
      0,
      0.468175,
      NULL,
      NULL,
      NULL,
      0.010869,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.647973,
      3.188003,
      3.664165,
      NULL,
      0.815802,
      3.598102,
      0.230615,
      NULL,
      1.144157,
      0,
      0.771689,
      NULL,
      0.387654,
      0,
      0.665118,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.050591,
      '31332',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.719485,
      '',
      '',
      NULL,
      NULL,
      6,
      1.662783,
      NULL,
      1,
      NULL,
      2.050531,
      3,
      1);
commit;
end;
/


