set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      '34243013',
      NULL,
      10.748289,
      '1214031',
      80,
      6,
      1.209555,
      3,
      '123124',
      NULL,
      ' 4-17-1974',
      NULL,
      89.830831,
      0,
      NULL,
      1,
      1.323101,
      3.162801,
      1.655008,
      1.909588,
      NULL,
      1.205508,
      3.004146,
      NULL,
      NULL,
      0.928899,
      NULL,
      1,
      3.461817,
      2,
      1.359143,
      NULL,
      0.127384,
      0,
      NULL,
      1.215671,
      NULL,
      NULL,
      0,
      2,
      5.572971,
      0.434761,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      4,
      2,
      0.887982,
      0,
      NULL,
      0.681489,
      1.566252,
      NULL,
      2,
      NULL,
      0.705913,
      3,
      NULL,
      3,
      3.106545,
      2,
      0,
      NULL,
      3.719756,
      0.695686,
      10.513874,
      NULL,
      1,
      1,
      1.717580,
      NULL,
      NULL,
      0.584033,
      NULL,
      NULL,
      1,
      3.973360,
      NULL,
      NULL,
      1,
      5,
      2.425672,
      1,
      0,
      2.633306,
      0.630509,
      5.086926,
      NULL,
      0,
      0.119648,
      NULL,
      0.657863,
      NULL,
      1,
      NULL,
      1,
      0,
      5.643188,
      1.394122,
      1.205890,
      3.694656,
      2,
      1,
      NULL,
      1,
      1,
      0,
      0.528083,
      NULL,
      1.557428,
      1,
      1.700422,
      4.662741,
      NULL,
      3,
      4.870266,
      NULL,
      6,
      NULL,
      6.222542,
      1.987695,
      1.321163,
      0.237906,
      1,
      1,
      NULL,
      1.668199,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.351818,
      NULL,
      1,
      2,
      1,
      NULL,
      0.377483,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1.002705,
      1.245178,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243803,
      NULL,
      3.501861,
      NULL,
      2.467714,
      3.213638,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761713,
      1,
      0,
      0.648189,
      0.313760,
      1.375626,
      0.324306,
      1.327031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '14034',
      '',
      '',
      1.945905,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      4.306647,
      3.270449,
      2.812426,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2.039497);
commit;
end;
/


