set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02111140',
      48.749265,
      70.573494,
      '1434214',
      92.357931,
      2,
      1.773093,
      1,
      '112124',
      1,
      ' 0- 9-1990',
      16,
      197.705931,
      0,
      NULL,
      1.395481,
      1,
      0,
      0,
      0.744571,
      3.257092,
      0.162398,
      NULL,
      0.690946,
      1,
      4.986909,
      1.073940,
      1.786005,
      NULL,
      4,
      1.799067,
      NULL,
      1,
      NULL,
      1,
      0.899617,
      1,
      8,
      0,
      4,
      1.285201,
      4.514009,
      0.895484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      1,
      3,
      3,
      1,
      NULL,
      3,
      NULL,
      1.163825,
      0,
      2,
      0,
      1.546374,
      2.947590,
      NULL,
      1.034505,
      1,
      1.936283,
      0,
      1.505969,
      1.587115,
      1.112823,
      8,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.140311,
      6,
      2,
      0,
      2.385584,
      7.346678,
      5.646072,
      0,
      NULL,
      7,
      3.687097,
      3.115377,
      0.989646,
      NULL,
      0,
      0,
      0.987584,
      1.217160,
      NULL,
      NULL,
      NULL,
      1.689918,
      1.968736,
      0,
      0.263227,
      6,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1.308744,
      1.806436,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.884432,
      6,
      NULL,
      5.734291,
      4,
      1,
      2.225581,
      NULL,
      0,
      1.970606,
      3,
      0.208094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.209887,
      1,
      2,
      1.595897,
      1,
      3.572326,
      1.846871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.723213,
      NULL,
      1.292288,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.507058,
      0.164016,
      1.232421,
      NULL,
      2,
      2,
      NULL,
      3.744413,
      0.435266,
      0.842945,
      1,
      0.583459,
      1,
      NULL,
      0,
      0.045408,
      1,
      0.810204,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '44012',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      1.920183,
      NULL,
      4.781598,
      3,
      3,
      3.059678,
      3,
      1.802255);
commit;
end;
/


