set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3121',
      '12104224',
      68,
      59.353352,
      '2002214',
      NULL,
      6,
      0,
      3,
      '130331',
      0,
      ' 9-16-1977',
      61.602203,
      51.300147,
      NULL,
      NULL,
      1.882060,
      NULL,
      1.457662,
      1,
      0.009194,
      0.285978,
      1.407289,
      NULL,
      0.296564,
      0,
      6.575780,
      0.381591,
      1,
      NULL,
      0,
      0,
      3.543148,
      1.834184,
      NULL,
      0.541906,
      2,
      1.526312,
      NULL,
      NULL,
      2,
      5.886932,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5.945923,
      0,
      1.153543,
      1.164421,
      0,
      1.159956,
      2.302231,
      NULL,
      3,
      1,
      1,
      1.660784,
      0.463288,
      NULL,
      1.468105,
      0,
      NULL,
      0,
      1.085332,
      1.215935,
      6,
      0,
      NULL,
      0.675616,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.746646,
      1.467469,
      NULL,
      1.232909,
      NULL,
      1.093932,
      6,
      1.796827,
      3,
      2,
      5,
      1.803525,
      1.813275,
      1,
      NULL,
      1,
      1.022923,
      1,
      1.140691,
      NULL,
      NULL,
      NULL,
      NULL,
      4.173781,
      1.746360,
      5.553055,
      5.709894,
      1.417570,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.576485,
      1,
      1,
      NULL,
      3.326489,
      5.697611,
      4.859123,
      1,
      6,
      NULL,
      5.189801,
      5.158950,
      1,
      0.333077,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.735476,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.023056,
      NULL,
      0,
      NULL,
      0.838357,
      0,
      3.152800,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.954288,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      1,
      0,
      1.680464,
      NULL,
      1.556544,
      NULL,
      1.602925,
      1.254264,
      1,
      1,
      0.329993,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960336,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724235,
      NULL,
      NULL,
      NULL,
      NULL,
      1.729644,
      NULL,
      0.816312,
      NULL,
      1.993029,
      0.635997,
      0.632122,
      NULL,
      1.415763,
      '03420',
      '',
      '',
      1,
      '',
      '',
      '',
      1.087758,
      '',
      NULL,
      '',
      NULL,
      0,
      0,
      2.996427,
      0.816197,
      1.923582,
      0.761306,
      NULL,
      NULL);
commit;
end;
/


