set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0143',
      '14221304',
      41,
      85.948317,
      '3203141',
      NULL,
      1,
      1.642306,
      3,
      '104343',
      NULL,
      ' 6-26-1978',
      4.941850,
      41.096106,
      1.854834,
      NULL,
      1.979045,
      1.308022,
      NULL,
      0.715537,
      1,
      0,
      1.090735,
      NULL,
      0.374522,
      1,
      8.247789,
      1,
      0,
      4,
      0.500174,
      0,
      4,
      0,
      0.934438,
      1.498121,
      0,
      NULL,
      NULL,
      1,
      4.216597,
      NULL,
      2,
      0.626640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.803385,
      3,
      1.488091,
      0,
      1,
      1.081252,
      3,
      2.141169,
      1,
      3,
      3,
      1.656177,
      3.463089,
      0,
      0,
      3,
      0.870132,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      2,
      3,
      1.702383,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.885929,
      NULL,
      9.699137,
      NULL,
      2,
      0,
      7,
      NULL,
      0.189866,
      6.895408,
      4,
      0,
      1.305844,
      9.790575,
      0.332911,
      1,
      0.772240,
      0,
      0,
      NULL,
      0.058796,
      0.549952,
      NULL,
      5.066353,
      NULL,
      5.193200,
      5.293756,
      2.297857,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274026,
      1,
      0,
      2,
      1.473798,
      4,
      6,
      NULL,
      5.734404,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.417819,
      5.797766,
      2.568022,
      1,
      NULL,
      2,
      0.772262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      5.629148,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      6.885156,
      1.093371,
      4,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.772163,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.436594,
      0.250771,
      NULL,
      0,
      NULL,
      0.422994,
      0,
      1,
      0,
      0,
      1.875242,
      1,
      1,
      0.199560,
      0.820445,
      NULL,
      0,
      1.618090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.776632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810821,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.219829,
      0,
      NULL,
      1,
      NULL,
      1.547729,
      0,
      1.377124,
      '01231',
      '',
      '',
      1,
      '',
      '',
      '',
      0.670227,
      NULL,
      NULL,
      '',
      NULL,
      5.214005,
      3.899471,
      NULL,
      NULL,
      0.894009,
      1,
      3,
      3.134162);
commit;
end;
/


