set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4332',
      '40423241',
      25.243630,
      49,
      '2314242',
      55,
      NULL,
      NULL,
      NULL,
      '002143',
      NULL,
      ' 3-22-1983',
      16.012492,
      8.706305,
      0,
      NULL,
      0.456528,
      1.311863,
      2,
      1,
      NULL,
      0,
      1,
      3,
      0,
      1.085448,
      3.108527,
      0,
      NULL,
      6.940804,
      NULL,
      0,
      6,
      0.783257,
      1,
      1.730386,
      NULL,
      NULL,
      1,
      1,
      5.663423,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.537334,
      NULL,
      NULL,
      1,
      1.656745,
      2,
      1.583341,
      0,
      NULL,
      1,
      2,
      1.345437,
      1,
      NULL,
      1.196880,
      3,
      2.188113,
      3.718530,
      0.468872,
      1.205071,
      0.219791,
      NULL,
      NULL,
      2,
      5.239903,
      0.647001,
      NULL,
      NULL,
      0.346663,
      NULL,
      NULL,
      0,
      NULL,
      7.973708,
      NULL,
      NULL,
      4.375260,
      7,
      0.719647,
      3.356291,
      9,
      5.790789,
      NULL,
      1,
      NULL,
      0.695515,
      0,
      1,
      1.219502,
      0,
      NULL,
      1.299041,
      1,
      4,
      3,
      0.020557,
      4,
      4.806078,
      3.525700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638965,
      NULL,
      3.442408,
      0.522033,
      0.847288,
      3,
      4.767814,
      5.341680,
      1,
      NULL,
      2,
      1,
      3,
      4.826850,
      NULL,
      2,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.238073,
      2.911944,
      2,
      2,
      1.016586,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.027356,
      3.632828,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.235154,
      7,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.767891,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.793718,
      NULL,
      3.325044,
      3.702153,
      1,
      NULL,
      0,
      0,
      0.773245,
      0,
      0,
      1.592773,
      1.129923,
      0,
      1,
      NULL,
      1.675063,
      0.605475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.503020,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780728,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.014412,
      NULL,
      0,
      0.829684,
      0,
      2,
      3.665206,
      '43301',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      3,
      1.898261,
      2.609451,
      3.221453,
      2,
      1);
commit;
end;
/


