set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '414',
      '14',
      36,
      13.633324,
      '2002111',
      204,
      1,
      3.400064,
      0,
      '342441',
      2.395942,
      ' 6-24-1989',
      55.384079,
      24,
      1.077715,
      NULL,
      3.080691,
      1,
      1,
      1.249578,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1.033309,
      0,
      1.970680,
      NULL,
      0,
      1.517237,
      0.997050,
      NULL,
      1.683685,
      1,
      1.649023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689861,
      1.771526,
      0.845168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.393482,
      0.330925,
      0.884925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402434,
      NULL,
      1,
      0,
      NULL,
      0.945094,
      0.697754,
      1.848344,
      0,
      NULL,
      0,
      0.645899,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.598426,
      NULL,
      1,
      NULL,
      1.212106,
      0.644661,
      0,
      1,
      6,
      0.359656,
      4,
      5.103133,
      3.291612,
      NULL,
      0.319837,
      0.192496,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.748670,
      6.276223,
      4,
      NULL,
      8,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.108453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342598,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.040449,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.883086,
      NULL,
      NULL,
      NULL,
      NULL,
      3.882162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727385,
      1.985596,
      NULL,
      NULL,
      NULL,
      6.962649,
      NULL,
      4.686969,
      0.660629,
      0.403153,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.619863,
      0.172800,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631595,
      0.170829,
      0.216168,
      1,
      3,
      2,
      2.793091,
      0.997401,
      1,
      3,
      2.553124,
      0.557516,
      1.314100,
      1.690773,
      0,
      1.072938,
      1.173909,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '20413',
      '',
      '',
      1.326555,
      '',
      '',
      '',
      1.683956,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


