set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '422',
      '04423321',
      NULL,
      NULL,
      '2240012',
      195,
      5,
      NULL,
      3,
      NULL,
      5,
      ' 5-27-1987',
      36,
      8,
      0.047751,
      NULL,
      NULL,
      1,
      0,
      0,
      1.727431,
      3.797852,
      1.702265,
      1.915580,
      0.471207,
      NULL,
      1,
      0.275910,
      1,
      0.214466,
      NULL,
      NULL,
      0,
      1.226445,
      0,
      1.728374,
      1.195539,
      0,
      0.711299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.189087,
      NULL,
      NULL,
      0.610148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520560,
      NULL,
      0.378190,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.350957,
      1,
      0.377127,
      0.498413,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1.958650,
      NULL,
      1.465253,
      NULL,
      NULL,
      0.795112,
      NULL,
      0,
      0.868190,
      1.412402,
      3,
      1,
      0.559828,
      3,
      2,
      NULL,
      NULL,
      4.791485,
      2,
      7.574634,
      NULL,
      NULL,
      9.298781,
      NULL,
      5.169986,
      NULL,
      6,
      0.869559,
      NULL,
      5.261322,
      1,
      NULL,
      NULL,
      1.518648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209334,
      0.604593,
      0,
      0,
      NULL,
      0.419108,
      1.128748,
      0.940212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508164,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.248600,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.954342,
      0.987583,
      7,
      0,
      2.560456,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.190163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0,
      2,
      1.444752,
      0,
      1.562596,
      0,
      1.405603,
      0,
      1,
      0.303738,
      NULL,
      1.940545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '04414',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      1.984347,
      '',
      NULL,
      '',
      3.857733,
      3,
      0,
      3,
      1.865072,
      1,
      2,
      3,
      NULL);
commit;
end;
/


