set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '213',
      '03221023',
      NULL,
      0,
      '3410444',
      304.425775,
      5,
      NULL,
      NULL,
      NULL,
      1.167470,
      ' 3-19-1985',
      8,
      151.576951,
      NULL,
      NULL,
      NULL,
      1.433733,
      0,
      0.559973,
      0,
      0,
      3,
      NULL,
      1,
      1,
      4.157416,
      0.716438,
      NULL,
      3.746749,
      0.212310,
      1,
      NULL,
      0.585487,
      3.474949,
      1.413875,
      1,
      1.403245,
      2.417159,
      1,
      3.960459,
      NULL,
      NULL,
      0.752223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188361,
      0.648032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931023,
      NULL,
      0.343578,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.930238,
      NULL,
      0,
      5,
      1.111640,
      0,
      NULL,
      1.299772,
      2,
      NULL,
      1,
      0,
      3.945462,
      1.595814,
      0,
      1,
      1.514147,
      0,
      NULL,
      0.980872,
      3,
      1.162268,
      3,
      7.496211,
      0.102693,
      4.076228,
      NULL,
      1.462866,
      3.002318,
      4.047333,
      9,
      2.605283,
      0.778211,
      0,
      7.985449,
      0,
      11.864120,
      NULL,
      6,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.374177,
      1.183358,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575312,
      1.098770,
      0,
      0,
      0.941992,
      1,
      1.827923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.829835,
      2,
      1.804075,
      NULL,
      NULL,
      NULL,
      1,
      3.285804,
      NULL,
      1,
      NULL,
      0,
      1.174015,
      NULL,
      NULL,
      NULL,
      0.487494,
      6,
      0.274319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.540639,
      1,
      3.633623,
      3.245382,
      NULL,
      1.143608,
      2.620355,
      3,
      0.224270,
      0,
      NULL,
      1,
      NULL,
      0.745972,
      1,
      NULL,
      0.483918,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.775148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      0.102441,
      5.543065,
      1,
      2.682023,
      2.846914,
      2.190498,
      3.339485,
      0.705734,
      NULL);
commit;
end;
/


