set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      '20331030',
      9,
      71,
      '1213032',
      141,
      2,
      1,
      0,
      '304304',
      NULL,
      ' 6-28-1992',
      NULL,
      NULL,
      1.454559,
      NULL,
      NULL,
      0,
      1.106419,
      NULL,
      0,
      1.780988,
      2,
      2.690823,
      1,
      0.817329,
      4,
      1.665052,
      NULL,
      4.299342,
      1,
      1,
      NULL,
      NULL,
      0.506308,
      0,
      1.718820,
      1.712277,
      NULL,
      0,
      NULL,
      NULL,
      1.066877,
      1.833323,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.517611,
      1.380226,
      0,
      NULL,
      NULL,
      0.945162,
      2,
      0.214463,
      NULL,
      0,
      2.635696,
      1,
      1,
      0.374287,
      0.570983,
      0.292160,
      0.382716,
      3.446926,
      3.921998,
      1,
      NULL,
      1.450484,
      9,
      0,
      NULL,
      1.044768,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.237831,
      NULL,
      1,
      0,
      0.098329,
      0,
      NULL,
      0,
      1,
      1.255484,
      0,
      1,
      1.300821,
      4.421344,
      0.065369,
      NULL,
      1.421878,
      1.095979,
      1,
      NULL,
      0.328991,
      9.800076,
      9.234583,
      0.621924,
      6,
      1,
      5.501910,
      0.359111,
      NULL,
      NULL,
      7.006189,
      0,
      2,
      3,
      NULL,
      5,
      9,
      NULL,
      10,
      2.169925,
      0,
      8.166325,
      4.125505,
      5.270100,
      9,
      2,
      3.303387,
      5.007843,
      NULL,
      1.382209,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.924714,
      1,
      0,
      0,
      2,
      1.487393,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      1,
      2,
      2.026957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      10.673347,
      5,
      5.737481,
      0,
      0.343996,
      NULL,
      NULL,
      NULL,
      NULL,
      8.709835,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.089353,
      0.193265,
      2.111544,
      0.470499,
      2.431809,
      2.112999,
      2,
      3,
      2,
      NULL,
      3,
      1.342663,
      NULL,
      0.943932,
      0.699666,
      0.822497,
      0.230023,
      0.055628,
      0.323041,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.323650,
      '20201',
      '',
      '',
      0,
      '',
      '',
      '',
      0.074288,
      NULL,
      '',
      '',
      1.347845,
      1,
      3.542791,
      0.057043,
      3,
      2.570181,
      3.895823,
      3.683035,
      3.513408);
commit;
end;
/


