set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1102',
      '33200102',
      46,
      10,
      '0201304',
      NULL,
      6,
      3.842275,
      3,
      '422414',
      1.579655,
      NULL,
      28,
      NULL,
      1,
      NULL,
      2.105346,
      1,
      0.026213,
      0,
      1.567155,
      0.514827,
      2.781998,
      2,
      1,
      0,
      NULL,
      1.986373,
      1.110344,
      1,
      1.495604,
      1.973108,
      0.348547,
      1,
      1,
      0,
      1.263468,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317697,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.742337,
      1.032503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219636,
      0,
      1.255559,
      1.378212,
      1.347308,
      0,
      1,
      0.598524,
      1.292046,
      1.289422,
      1.237140,
      0.745484,
      NULL,
      1.644327,
      0,
      1.663563,
      1.224598,
      0,
      1.216934,
      NULL,
      0,
      2,
      5,
      0,
      0.383794,
      0,
      0.050219,
      1,
      3.859799,
      NULL,
      0,
      1.442051,
      1.683401,
      1.032851,
      NULL,
      1,
      4,
      4.918198,
      1,
      9.615671,
      1,
      4.678455,
      NULL,
      0.713910,
      3.438362,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.806982,
      0.574876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0.061316,
      0.211578,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881853,
      NULL,
      NULL,
      NULL,
      NULL,
      3.780563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.275568,
      2.213515,
      NULL,
      1,
      NULL,
      NULL,
      0.008648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028154,
      NULL,
      0.074033,
      0.362934,
      NULL,
      NULL,
      2.098395,
      1,
      0.698781,
      3,
      0.866948,
      1.660481,
      1.793630,
      1,
      1,
      1,
      1.100021,
      1.850586,
      0.464371,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '00314',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.862342,
      '',
      NULL,
      '',
      3,
      1,
      0.793524,
      0.499683,
      1,
      1.086130,
      2,
      3,
      1);
commit;
end;
/


