set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2022',
      '14120110',
      37,
      2.057754,
      '3131021',
      2.459312,
      4,
      0,
      NULL,
      '143400',
      1.043977,
      ' 6-26-1977',
      NULL,
      15,
      0,
      NULL,
      NULL,
      1.739815,
      1.229348,
      1.226751,
      1,
      1.030085,
      NULL,
      2,
      NULL,
      0.494661,
      1.247006,
      1.733557,
      0.597360,
      0.865903,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1.301533,
      0,
      1.739826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.603010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302560,
      0.842878,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0.222521,
      NULL,
      NULL,
      0,
      0,
      1.889371,
      NULL,
      NULL,
      2.758349,
      NULL,
      NULL,
      0,
      1.228922,
      0.177960,
      NULL,
      1.295769,
      4,
      5.341743,
      1,
      4.406586,
      0,
      NULL,
      0,
      0.527940,
      NULL,
      3,
      1.054748,
      NULL,
      4.325226,
      1.071192,
      0.085713,
      6,
      NULL,
      9,
      8.075291,
      1,
      7,
      2.237846,
      NULL,
      6.193165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.259825,
      0.975417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860094,
      1,
      NULL,
      1,
      0.281518,
      1,
      0.410123,
      1.672868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310558,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.144331,
      0.317129,
      NULL,
      NULL,
      NULL,
      1.076875,
      NULL,
      4,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.341393,
      7.432534,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1.972613,
      0,
      3,
      NULL,
      3,
      1.937194,
      0,
      1,
      1.409203,
      0.022147,
      0,
      1.456487,
      NULL,
      0.478841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '22234',
      NULL,
      NULL,
      0.396131,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      6,
      0.663821,
      2.956998,
      1,
      2,
      2,
      3.383536,
      NULL,
      2.684602);
commit;
end;
/


