set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3104',
      '42043031',
      19,
      35.752468,
      '3224344',
      189.087326,
      2,
      1,
      1,
      '410400',
      3.944556,
      ' 7-11-1988',
      3,
      54,
      NULL,
      NULL,
      3.977021,
      0,
      1.428693,
      0,
      2,
      0.939808,
      NULL,
      NULL,
      1.123061,
      0,
      1.417628,
      0.209733,
      1.767239,
      NULL,
      0.552617,
      0.430640,
      0,
      0,
      0,
      1,
      0.495992,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.071549,
      1.894311,
      1.812000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.088594,
      NULL,
      0.153002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073420,
      NULL,
      1,
      1,
      0,
      0,
      2.195535,
      1.506815,
      1,
      1.999381,
      1.124281,
      0.481919,
      0.147732,
      1,
      0.978786,
      1.354424,
      0,
      0,
      0,
      NULL,
      0.614651,
      4.346976,
      0,
      NULL,
      3.660143,
      0,
      5,
      NULL,
      2.859390,
      4.191171,
      NULL,
      5.883359,
      5.124631,
      2,
      5,
      NULL,
      NULL,
      8,
      3.998706,
      4,
      NULL,
      10.901859,
      7.159072,
      11.460183,
      1,
      NULL,
      NULL,
      4,
      1.579810,
      NULL,
      NULL,
      2.833001,
      1.682546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.585088,
      1,
      0,
      0,
      NULL,
      0,
      0.752828,
      1.869423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.404517,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.125053,
      NULL,
      NULL,
      0,
      2.376774,
      1.599666,
      3.804734,
      1.882630,
      NULL,
      NULL,
      NULL,
      5,
      1,
      8.625144,
      2.037707,
      1.936105,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.280930,
      4,
      1.477093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.616570,
      NULL,
      0.930206,
      1.762687,
      2.962098,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      0,
      0.316348,
      1.781659,
      1.173823,
      1.073017,
      0.990590,
      0.530903,
      0.467420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816831,
      '00434',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.115537,
      '',
      '',
      '',
      0,
      1.808378,
      0.449326,
      3,
      1,
      1.127177,
      3.826346,
      0.920806,
      1);
commit;
end;
/


