set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4344',
      '32040034',
      32.066344,
      NULL,
      '3003001',
      NULL,
      6,
      NULL,
      1,
      '131400',
      NULL,
      ' 7- 5-1982',
      10,
      106.383483,
      NULL,
      NULL,
      1,
      0,
      1,
      1.304252,
      1.626965,
      1,
      2,
      3.695983,
      1.327267,
      NULL,
      0,
      0,
      1.600700,
      0.044360,
      NULL,
      1,
      1,
      0.781889,
      NULL,
      0,
      0.071149,
      NULL,
      0.988184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.003264,
      0.048697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.483154,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996476,
      1,
      1.114594,
      0,
      0.077832,
      0,
      NULL,
      0.695237,
      1,
      2,
      0.369495,
      0,
      0.103956,
      1.957817,
      NULL,
      0,
      0,
      1.058660,
      1,
      NULL,
      0,
      3,
      0.912065,
      1,
      3.210099,
      NULL,
      2,
      1.942100,
      3.690974,
      4.512537,
      3.105726,
      0,
      NULL,
      5.675033,
      2.652486,
      1,
      6,
      7.383905,
      0,
      6,
      2.051111,
      9,
      NULL,
      8,
      5.948574,
      0,
      NULL,
      3.714008,
      1.235016,
      NULL,
      NULL,
      2.342395,
      0.683413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0.870591,
      1.022163,
      0.917549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.796499,
      0.733050,
      1.084526,
      0.321361,
      NULL,
      3.705338,
      10.912898,
      0.331693,
      0.967504,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.655064,
      0.200094,
      1,
      0.852587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047887,
      1.579686,
      0.892007,
      0.041456,
      0,
      3,
      1,
      0,
      0,
      1,
      0.776429,
      1,
      1,
      0.746137,
      NULL,
      0.706304,
      1,
      0,
      1,
      1.075954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '43143',
      '',
      '',
      1.606066,
      '',
      '',
      '',
      1.424472,
      '',
      '',
      '',
      NULL,
      3,
      3.802853,
      1,
      NULL,
      1,
      0.155692,
      2.598010,
      2.578038);
commit;
end;
/


