set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11',
      10.780262,
      5.304883,
      '0122411',
      NULL,
      NULL,
      0.076832,
      3,
      '124331',
      5.259433,
      NULL,
      52.801247,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      2.006920,
      0.829500,
      0,
      1.402633,
      NULL,
      2,
      0,
      1,
      0.139058,
      NULL,
      3.347967,
      5,
      0.260032,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      3.303847,
      1,
      1.833183,
      0,
      NULL,
      NULL,
      0.790851,
      NULL,
      NULL,
      3.573107,
      0,
      0.038895,
      0.584149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.060984,
      1,
      NULL,
      1,
      1.915268,
      0,
      NULL,
      1.952474,
      0,
      1.830783,
      1.680186,
      NULL,
      NULL,
      1,
      0,
      0.902595,
      0.927022,
      NULL,
      1,
      3,
      1.041059,
      0.012075,
      1.134132,
      1.023319,
      NULL,
      1,
      6.099922,
      1,
      3,
      0.621175,
      3,
      3.775166,
      0,
      NULL,
      2.143803,
      1,
      2.709318,
      NULL,
      8.888770,
      8.276944,
      NULL,
      11.366119,
      2.318571,
      0.136656,
      0,
      1.849247,
      3.255202,
      1.591376,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032974,
      0,
      1,
      0,
      1,
      0,
      1.258562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430923,
      NULL,
      NULL,
      NULL,
      NULL,
      0.320036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.585697,
      1,
      NULL,
      NULL,
      NULL,
      5.124897,
      1.603733,
      1.226648,
      6,
      1.620310,
      1,
      1.913629,
      NULL,
      NULL,
      NULL,
      1,
      5.472160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.788121,
      1.800150,
      NULL,
      1.319862,
      NULL,
      1.601237,
      0,
      3,
      1,
      0.947161,
      0.661620,
      0.448390,
      0.271567,
      0.448838,
      NULL,
      1,
      NULL,
      1,
      1.861187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '13243',
      '32234',
      '',
      0.057635,
      '',
      '',
      '',
      1.490574,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


