set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13',
      27,
      24.400765,
      '4200220',
      15,
      6,
      NULL,
      NULL,
      '110211',
      NULL,
      ' 3-11-1978',
      NULL,
      32.991766,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      1.537660,
      NULL,
      2,
      0.922014,
      0.220556,
      NULL,
      7.624688,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.337962,
      0,
      0,
      5.653409,
      0,
      NULL,
      NULL,
      1,
      1.262419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321678,
      0.481030,
      4.307227,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.273997,
      3,
      0,
      0.512057,
      2.839634,
      NULL,
      1,
      3,
      0.395868,
      3.977071,
      1.093140,
      1.135610,
      1,
      7,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.275781,
      0.282230,
      1,
      1,
      NULL,
      1,
      0.384633,
      1,
      1.140513,
      NULL,
      1,
      0,
      1,
      NULL,
      1.280332,
      0,
      1.753720,
      1,
      0,
      NULL,
      NULL,
      0.596787,
      0,
      0.148193,
      1.239313,
      1.211607,
      NULL,
      1.324481,
      0,
      0,
      1.349898,
      0.331443,
      1.645775,
      1,
      0,
      NULL,
      1.805772,
      3,
      1,
      NULL,
      4,
      NULL,
      5,
      NULL,
      4.521189,
      0.034464,
      NULL,
      0.893416,
      1,
      1.083411,
      0.688094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.806365,
      NULL,
      NULL,
      NULL,
      0.260506,
      1,
      0.993942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      7.443650,
      1,
      NULL,
      0,
      1.148887,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.809557,
      0,
      0,
      3,
      NULL,
      NULL,
      1,
      2,
      1.869287,
      0.405217,
      NULL,
      0,
      1.536332,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087176,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.561616,
      NULL,
      1.986930,
      0.171545,
      0.991186,
      NULL,
      3,
      '44314',
      NULL,
      '',
      1.621218,
      '',
      NULL,
      '',
      1.966043,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


