set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      34,
      15,
      '4342311',
      36,
      1,
      2,
      3,
      NULL,
      5,
      ' 7-26-1978',
      9.957776,
      72,
      0.640190,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.883250,
      1,
      0,
      0.781844,
      0.230833,
      1.461026,
      4.414751,
      0,
      1.646408,
      1.076469,
      1.236110,
      4.649057,
      5.760768,
      2.714433,
      0.952025,
      7,
      NULL,
      NULL,
      1.418258,
      0,
      5,
      1.979676,
      2,
      0.427052,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10.850217,
      NULL,
      0,
      3.196168,
      1,
      1.742625,
      1.983363,
      2,
      1.803630,
      3,
      NULL,
      1.858535,
      NULL,
      0,
      1.255638,
      0.807787,
      3.989632,
      NULL,
      2.371120,
      NULL,
      1,
      NULL,
      11.619866,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.400390,
      1,
      0,
      NULL,
      1.899201,
      1.755027,
      1.567933,
      0,
      0.969279,
      0,
      0.676207,
      1,
      0.554755,
      2,
      0.604528,
      0,
      1.650726,
      0.599940,
      0,
      NULL,
      0.698859,
      NULL,
      0.845063,
      0,
      0.303935,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.181884,
      0.359507,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0,
      6,
      3.199355,
      2.812104,
      2,
      1.109721,
      NULL,
      0,
      0.086504,
      3,
      1,
      1.802710,
      6.022182,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.447631,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.640294,
      NULL,
      3,
      NULL,
      1.413826,
      1.446716,
      0,
      0.066460,
      0.478600,
      NULL,
      1,
      NULL,
      0.791130,
      NULL,
      NULL,
      NULL,
      1.524485,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      0.319843,
      1,
      0.630926,
      3,
      2.688384,
      1.095463,
      NULL,
      0.091430,
      NULL,
      1,
      1.043927,
      NULL,
      0.830950,
      NULL,
      1,
      0.442445,
      1.098375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.215894,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.889262,
      0,
      NULL,
      0.565924,
      0.228916,
      0.591286,
      NULL,
      5,
      '04414',
      '11324',
      '',
      NULL,
      NULL,
      '',
      '',
      1.279789,
      '',
      '',
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


