set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32',
      3,
      23,
      '0333324',
      6,
      6,
      2,
      NULL,
      '003141',
      5,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      1.706276,
      0,
      1.146264,
      1,
      0.444819,
      NULL,
      1.163391,
      0.746239,
      1.792868,
      1.250255,
      0,
      1.231331,
      1,
      5,
      2.100466,
      NULL,
      2,
      0,
      1.114032,
      NULL,
      5.049807,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0.440756,
      NULL,
      NULL,
      3,
      0.729181,
      3.988511,
      1.237134,
      0.169185,
      NULL,
      2.940301,
      1.925343,
      1.554182,
      1.335357,
      NULL,
      0,
      1,
      0,
      2,
      0,
      NULL,
      0.614573,
      0.036707,
      9.571241,
      0.929361,
      1,
      NULL,
      0,
      1,
      0.571859,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522873,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0.386208,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1.942972,
      NULL,
      1,
      NULL,
      1.653918,
      1.728961,
      NULL,
      NULL,
      1.894422,
      NULL,
      5.016279,
      NULL,
      NULL,
      NULL,
      3,
      2.480682,
      3.320941,
      NULL,
      6,
      NULL,
      0,
      8,
      4.421101,
      NULL,
      1,
      8,
      NULL,
      0.410692,
      0,
      NULL,
      1.569867,
      1,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801878,
      0,
      0,
      0.594014,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.511000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.342385,
      NULL,
      1.082931,
      1.811944,
      0,
      0.633635,
      1,
      NULL,
      0,
      1.689647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.354255,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      2.049862,
      0,
      2.735385,
      0,
      1,
      0.867572,
      2,
      1.962766,
      NULL,
      1,
      1.190307,
      NULL,
      0.485092,
      NULL,
      1.708557,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132735,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.537338,
      NULL,
      NULL,
      0.720916,
      0,
      1.912472,
      2,
      2.047287,
      '02313',
      '32211',
      '',
      NULL,
      '',
      '',
      '',
      1.567766,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


