set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40',
      26.473707,
      13.865115,
      '1313332',
      17.492311,
      4,
      0,
      1,
      '312012',
      NULL,
      '11-27-2003',
      50,
      45.125799,
      0.110022,
      NULL,
      0.700914,
      1,
      1.367378,
      1.780626,
      0.686666,
      1,
      0,
      0,
      0.001486,
      0.104715,
      7.360638,
      1.735372,
      1,
      0,
      0.302641,
      5,
      1,
      2.021791,
      NULL,
      1.486522,
      1,
      1.413846,
      0.865621,
      NULL,
      2,
      3,
      2,
      1.681164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.810801,
      NULL,
      NULL,
      1.502106,
      0.551719,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      2.332539,
      3,
      0.675889,
      NULL,
      1,
      5,
      1,
      0,
      1.278903,
      1,
      NULL,
      NULL,
      1.455178,
      NULL,
      NULL,
      NULL,
      0,
      0.635659,
      NULL,
      NULL,
      1.174043,
      0.651115,
      1,
      NULL,
      0.866369,
      1,
      0,
      1.776262,
      1,
      0,
      0.043993,
      0,
      1,
      1,
      NULL,
      0,
      5.961776,
      1.011002,
      NULL,
      0.131202,
      1.321304,
      4,
      0.906296,
      NULL,
      1,
      1.411446,
      5.602121,
      2.088306,
      NULL,
      0.152402,
      0,
      1,
      3.853635,
      1,
      2.031462,
      6.864384,
      5.305102,
      5.626887,
      1.801852,
      7,
      1.514235,
      1.161997,
      0.410898,
      NULL,
      NULL,
      0,
      NULL,
      0.444537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.167205,
      NULL,
      NULL,
      0.977167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.268052,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.229307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.477776,
      0,
      0.029521,
      0,
      1,
      1.714992,
      1.533694,
      1.263546,
      0.388871,
      2,
      3,
      NULL,
      1,
      1,
      0.419559,
      0,
      NULL,
      1.989558,
      1.414825,
      0.952081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.113568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011488,
      0,
      NULL,
      NULL,
      NULL,
      1.351213,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186413,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605957,
      0.582174,
      0.235194,
      NULL,
      1,
      1.519570,
      0.260129,
      2,
      5,
      '02012',
      NULL,
      NULL,
      1.653707,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


