set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      '03',
      32,
      1.514367,
      '3134040',
      NULL,
      0,
      NULL,
      NULL,
      '402201',
      NULL,
      '10- 9-1995',
      31.147668,
      26.475479,
      1,
      NULL,
      0,
      0,
      3.179469,
      0.550571,
      NULL,
      NULL,
      0.995016,
      1.579583,
      1,
      1,
      6,
      NULL,
      0.356402,
      NULL,
      0.171706,
      2.164046,
      NULL,
      5.139473,
      5.992484,
      2,
      1.780305,
      NULL,
      0,
      0,
      2,
      1.637729,
      2,
      NULL,
      NULL,
      NULL,
      1.043074,
      NULL,
      NULL,
      6.579173,
      2.474200,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0.877328,
      1,
      1.960673,
      0.808720,
      NULL,
      1.504469,
      NULL,
      1,
      1,
      1.337553,
      NULL,
      3.784786,
      0,
      NULL,
      5.322425,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.717249,
      NULL,
      1,
      0.060240,
      0.184813,
      1,
      0.175308,
      1,
      1.343705,
      0.490400,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0.810459,
      NULL,
      1.788729,
      0,
      NULL,
      1.051260,
      0.045349,
      0,
      1,
      0.036732,
      NULL,
      NULL,
      NULL,
      NULL,
      2.602519,
      1.396896,
      4,
      1,
      3.896354,
      0.029394,
      7.001761,
      8.360398,
      4.832661,
      0,
      6,
      NULL,
      1,
      1.825917,
      NULL,
      0.874322,
      3,
      1,
      1,
      5.668877,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.084831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213796,
      NULL,
      1.925170,
      1.664466,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.805991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941830,
      NULL,
      1.336873,
      0.379006,
      1,
      0.298751,
      2.155066,
      NULL,
      2.893290,
      0,
      0.972199,
      0,
      1,
      0,
      1.798181,
      NULL,
      NULL,
      NULL,
      0.009446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.897100,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.236030,
      0,
      NULL,
      NULL,
      0,
      0.742624,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560474,
      1,
      0.925460,
      NULL,
      0.541676,
      0.359911,
      0.620779,
      0,
      1.912721,
      '21331',
      '14414',
      NULL,
      0.558675,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


