set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      '00',
      50,
      13,
      '0444220',
      25.162041,
      NULL,
      0.502158,
      3,
      '314043',
      3.143952,
      NULL,
      31.028047,
      51,
      1,
      NULL,
      1.901483,
      1,
      0,
      0,
      0.108201,
      NULL,
      NULL,
      0,
      0,
      0.631235,
      3,
      0,
      0,
      1.943627,
      0.953737,
      NULL,
      2,
      4,
      0,
      NULL,
      1,
      0.792142,
      NULL,
      0,
      5.341866,
      1,
      2.450815,
      NULL,
      NULL,
      NULL,
      0.317961,
      NULL,
      NULL,
      0.479296,
      0,
      0,
      2,
      NULL,
      NULL,
      3.175428,
      0.450820,
      NULL,
      NULL,
      1,
      1.601204,
      NULL,
      3,
      3.739253,
      1,
      2.306511,
      1.766511,
      1,
      6.574063,
      1,
      1.506210,
      5,
      1,
      NULL,
      3.768672,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162861,
      1.868030,
      1.109713,
      0.544895,
      0,
      1,
      1.345105,
      0,
      0.807087,
      NULL,
      0,
      1.610659,
      0.461097,
      1,
      0,
      0,
      NULL,
      1,
      0.425554,
      NULL,
      0.186082,
      1,
      1,
      0.224939,
      1.738418,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.974244,
      0,
      4,
      6,
      4.409118,
      0.966623,
      7.717258,
      3,
      7.824193,
      9,
      7.274497,
      0.236408,
      1.379678,
      1,
      0.684327,
      1,
      1.147488,
      3,
      0.972724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0.942311,
      0,
      1.170947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.821643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645523,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.162608,
      NULL,
      1,
      1,
      0,
      0.979059,
      1.819270,
      1.502206,
      1,
      0.601392,
      3.588778,
      0.917379,
      1.275184,
      NULL,
      NULL,
      0.784512,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.837638,
      '21001',
      '04344',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      4,
      3,
      NULL,
      0,
      0.675006,
      1.506711,
      NULL,
      2.686805,
      NULL);
commit;
end;
/


