set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '224',
      '20041014',
      14.393198,
      NULL,
      '0312221',
      26.717213,
      6,
      2.351973,
      0,
      '303422',
      0,
      ' 4- 8-1988',
      NULL,
      16.719727,
      0,
      NULL,
      2,
      1.333155,
      NULL,
      1.518033,
      1,
      2,
      0,
      NULL,
      1,
      1,
      3,
      0,
      1.064001,
      0.248266,
      0.791380,
      6.784036,
      5,
      4,
      0.034861,
      2,
      1.003806,
      1.806486,
      6.493199,
      0,
      4,
      1.896601,
      3.941432,
      NULL,
      NULL,
      NULL,
      0.695602,
      NULL,
      NULL,
      2,
      0,
      1,
      2.735833,
      NULL,
      0.073458,
      NULL,
      2,
      NULL,
      2,
      2,
      1.229492,
      1,
      0,
      0.564004,
      1.983130,
      0,
      1,
      1.594036,
      7,
      1,
      0.638329,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974427,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      1,
      0,
      1.115354,
      0.854654,
      NULL,
      0.382507,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.581937,
      0.261311,
      0,
      3,
      0,
      1.809800,
      NULL,
      2.238258,
      3,
      NULL,
      1,
      2,
      2.130547,
      3,
      NULL,
      0,
      0,
      3,
      7,
      9,
      NULL,
      1,
      0.144610,
      2,
      1.269676,
      1,
      2.400215,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614986,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023456,
      6,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.138207,
      3.615951,
      NULL,
      0.108851,
      3,
      2,
      0.990380,
      0.727490,
      0.118680,
      3.129455,
      1,
      0,
      0,
      1,
      1,
      1.692752,
      1,
      1,
      0,
      NULL,
      1,
      1.375063,
      3,
      2.802649,
      1,
      1,
      0.546731,
      0,
      1.921154,
      NULL,
      NULL,
      1.713458,
      1,
      1,
      0.832049,
      1,
      1.678956,
      0,
      NULL,
      1.357762,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      '14004',
      '12023',
      '',
      1.906695,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.285260,
      0,
      0.739594,
      3,
      5.228045,
      2,
      0,
      0,
      0);
commit;
end;
/


