set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      '04433030',
      1.795726,
      0,
      '0433421',
      4.708705,
      6,
      3,
      2,
      '424323',
      2.703528,
      NULL,
      26,
      36,
      1.164751,
      NULL,
      0,
      0.591937,
      3,
      NULL,
      0.044786,
      3.241319,
      NULL,
      NULL,
      1.799057,
      0.806136,
      5.934914,
      1.958787,
      0.375816,
      1,
      1,
      2.502793,
      0,
      1.294683,
      NULL,
      0,
      1.793388,
      1.103564,
      0,
      1,
      4,
      1.447621,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.516844,
      2.845710,
      0.805665,
      2,
      1,
      0.631625,
      NULL,
      1.172566,
      0,
      3.229994,
      0.546771,
      NULL,
      0.901848,
      1.761762,
      0,
      1.884381,
      2,
      2,
      0.538808,
      4,
      1.128465,
      3.780440,
      0.260762,
      1,
      NULL,
      1.022365,
      0,
      NULL,
      NULL,
      0.859338,
      NULL,
      NULL,
      0,
      1.613339,
      1.982442,
      1,
      0,
      NULL,
      1.631138,
      1,
      1.423949,
      1,
      1,
      0.837121,
      1.206418,
      NULL,
      0,
      1.479804,
      0,
      1.607829,
      0,
      NULL,
      1.537787,
      0.423442,
      0.095338,
      1.320670,
      0,
      1,
      0,
      NULL,
      NULL,
      1.294114,
      1,
      NULL,
      2,
      3.235126,
      4,
      0,
      NULL,
      NULL,
      NULL,
      5.704478,
      7,
      NULL,
      NULL,
      NULL,
      8,
      0.688972,
      0.349578,
      1,
      0,
      NULL,
      NULL,
      0.780377,
      0.042433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272622,
      0,
      1,
      NULL,
      1,
      1.311330,
      1.632738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      0.215799,
      1,
      NULL,
      0,
      0,
      3.509398,
      0.957461,
      2,
      1,
      NULL,
      0,
      0.353062,
      0.734514,
      1,
      0.721693,
      1.889527,
      0,
      1,
      0,
      0,
      0,
      2.666462,
      1.085404,
      NULL,
      0.694117,
      0.452588,
      0.625788,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1.387015,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127474,
      0,
      0,
      NULL,
      NULL,
      0,
      0.837192,
      2,
      5.711058,
      NULL,
      '31001',
      '',
      1.199756,
      '',
      '',
      '',
      1.004340,
      NULL,
      NULL,
      '',
      1.516660,
      NULL,
      1,
      2,
      4.149158,
      2,
      2.060447,
      3,
      0);
commit;
end;
/


