set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '21042331',
      38,
      18,
      '3201203',
      10.522554,
      2,
      2.366072,
      NULL,
      '200012',
      NULL,
      ' 2-26-1993',
      9,
      7,
      0.701072,
      NULL,
      NULL,
      2,
      1.504649,
      NULL,
      1.318064,
      0,
      1,
      NULL,
      0,
      1.805254,
      6.160088,
      NULL,
      NULL,
      1.449801,
      NULL,
      NULL,
      5,
      2.083733,
      NULL,
      2,
      0,
      0,
      6,
      0,
      4.260852,
      3,
      3.731807,
      1.333862,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11.011759,
      1.132569,
      0,
      3.341910,
      0.493491,
      1.710719,
      0.730406,
      NULL,
      1.616446,
      NULL,
      3.652895,
      1,
      1.775820,
      0,
      3.781323,
      1.965598,
      2,
      1.970719,
      1.612213,
      10.464823,
      1.461456,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.466306,
      1.521796,
      0.959313,
      1.963580,
      NULL,
      0,
      0.876634,
      0.690542,
      0.591816,
      NULL,
      1,
      0.458369,
      0,
      0.104719,
      0.191367,
      NULL,
      0,
      NULL,
      1.327271,
      0,
      1.018412,
      1,
      NULL,
      NULL,
      0.693128,
      0,
      NULL,
      0.193663,
      2,
      1,
      1.361935,
      0,
      5.544948,
      0,
      NULL,
      2,
      3.392045,
      2,
      2,
      6.504389,
      4,
      NULL,
      NULL,
      0.976721,
      1.844485,
      0,
      3.641618,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.282775,
      1,
      0,
      NULL,
      1,
      1,
      1.204370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.672287,
      0.718110,
      2.112693,
      3,
      2.164129,
      1,
      0,
      1,
      0,
      1.576409,
      0.553340,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.287741,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811264,
      0.602953,
      0.118854,
      3.045069,
      1,
      NULL,
      0,
      3.013165,
      0.962785,
      3.865655,
      0.424435,
      0.371856,
      3,
      0.392605,
      0.446700,
      NULL,
      0.013796,
      1.004198,
      1.773260,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      0.938281,
      1,
      NULL,
      0,
      NULL,
      0.685257,
      0.973466,
      0.619627,
      0,
      1.530491,
      0,
      NULL,
      1.374355,
      0.629012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.894065,
      '04213',
      '14332',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      5,
      2.958973,
      2.175754,
      5.839078,
      0,
      3.931862,
      1.843142,
      3,
      1);
commit;
end;
/


