set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34311323',
      37.976706,
      60.639647,
      '4322111',
      50,
      1,
      2.244742,
      2,
      '411300',
      0,
      NULL,
      NULL,
      18.650188,
      0.625125,
      NULL,
      1,
      1,
      0,
      0,
      0.052108,
      0.100695,
      NULL,
      NULL,
      0.624160,
      NULL,
      NULL,
      0,
      0,
      1.694166,
      1,
      9.201665,
      4.062197,
      7.506763,
      5.569088,
      0.523130,
      1,
      NULL,
      3.857341,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.690647,
      NULL,
      NULL,
      9.542119,
      2,
      0,
      3,
      0.694050,
      1.802085,
      NULL,
      0.191657,
      0,
      0.470143,
      2.006986,
      0.161426,
      0,
      0.127442,
      NULL,
      1.364145,
      2.801475,
      0.156668,
      1.022272,
      11.520490,
      1.237895,
      0.058849,
      10.870718,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      2.886667,
      1.256616,
      2,
      0.435024,
      NULL,
      1.729778,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0.536167,
      NULL,
      0,
      0,
      NULL,
      0.866551,
      NULL,
      0.085334,
      0,
      1,
      0.679133,
      1.450907,
      3.496306,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228545,
      0,
      NULL,
      1,
      1,
      7,
      2.741820,
      6,
      7.205588,
      NULL,
      4,
      5.058578,
      1,
      0,
      0.805751,
      1.903319,
      2.599792,
      1.554051,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1.388994,
      0.560157,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733267,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.528582,
      NULL,
      1,
      NULL,
      5.609993,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.665712,
      NULL,
      NULL,
      NULL,
      1.289499,
      2.705795,
      0.194768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.329475,
      NULL,
      0.859830,
      0.677469,
      0.024998,
      3.839469,
      1.143830,
      0,
      NULL,
      1,
      1,
      0.252549,
      1,
      0.614642,
      1,
      1.616731,
      0,
      0,
      NULL,
      1,
      1,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      1.810313,
      1.260641,
      NULL,
      1.158366,
      1,
      0,
      0.890181,
      1,
      0,
      0,
      0.040370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '31414',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      1,
      NULL,
      1.011068,
      NULL,
      0,
      0,
      NULL,
      NULL);
commit;
end;
/


