set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22432011',
      21.446260,
      66,
      '2212211',
      68,
      4,
      3.037347,
      3,
      '142011',
      2.055175,
      ' 2- 1-1979',
      16,
      63,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.464081,
      3.779852,
      1.029166,
      1,
      1.207345,
      0.800597,
      3,
      1,
      1.412706,
      0.921942,
      0,
      7,
      6.696497,
      2,
      5,
      1.043780,
      1.958780,
      NULL,
      11.234380,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.982432,
      NULL,
      NULL,
      2.133834,
      0.365877,
      NULL,
      2.116969,
      NULL,
      1,
      1,
      0.667449,
      NULL,
      0.881022,
      3.871664,
      2,
      0.889758,
      1.186766,
      1,
      NULL,
      7.090265,
      0,
      1,
      11,
      NULL,
      2,
      0.480711,
      0.173942,
      NULL,
      NULL,
      1.294584,
      NULL,
      NULL,
      1.202064,
      NULL,
      2.540349,
      NULL,
      2,
      0.777802,
      1,
      1,
      1,
      0,
      1.484159,
      0.922916,
      NULL,
      NULL,
      0.266838,
      NULL,
      NULL,
      0,
      0.322521,
      NULL,
      0,
      0,
      1,
      1,
      0.759414,
      1.043804,
      1.652782,
      1,
      3,
      1.207016,
      1,
      2,
      3,
      0.655515,
      0,
      0.553058,
      0.816629,
      1.512078,
      NULL,
      6.894332,
      NULL,
      3,
      0,
      2.568050,
      6,
      1,
      1,
      1,
      0,
      0.224074,
      0.785076,
      2.703250,
      1.654393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191695,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.467828,
      2.620637,
      1,
      3.886044,
      0.904153,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.147045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.762808,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.766777,
      0.740761,
      1.493769,
      NULL,
      0,
      0.685232,
      1.250635,
      1.377349,
      1,
      0.754406,
      0.605040,
      NULL,
      1,
      0.364876,
      NULL,
      NULL,
      NULL,
      0.041882,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.102431,
      NULL,
      1.765537,
      0.235261,
      0.768035,
      1.381122,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44112',
      '43304',
      '',
      0,
      '',
      '',
      '',
      1.812224,
      '',
      NULL,
      '',
      NULL,
      NULL,
      3,
      NULL,
      1.438540,
      NULL,
      0,
      0,
      1.954212);
commit;
end;
/


