set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '41330214',
      33.517188,
      NULL,
      '3022043',
      99,
      6,
      1.781935,
      0,
      NULL,
      0,
      '10-24-1974',
      57,
      7.270363,
      NULL,
      NULL,
      NULL,
      0.540977,
      2,
      0,
      NULL,
      1,
      0.944380,
      0.576943,
      1.346129,
      1.877044,
      7,
      0,
      0.432184,
      0.421636,
      NULL,
      2,
      NULL,
      2.690451,
      1,
      1.337550,
      2.084002,
      0.283958,
      0,
      1,
      1,
      0.571876,
      NULL,
      1.689336,
      NULL,
      NULL,
      1.382343,
      NULL,
      NULL,
      7,
      1.917826,
      1,
      2,
      1.633512,
      NULL,
      2.050138,
      1.387162,
      1,
      0.491233,
      NULL,
      1,
      NULL,
      2,
      3.717300,
      1,
      2.107069,
      0,
      1,
      2.529261,
      0,
      0,
      8,
      0,
      0,
      3.038788,
      0,
      NULL,
      NULL,
      1.636957,
      NULL,
      NULL,
      1,
      3.551951,
      1,
      1.702577,
      NULL,
      0.064639,
      0.459694,
      0,
      1,
      1.628314,
      NULL,
      0.829967,
      1,
      1,
      0,
      0.226639,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.692205,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.585663,
      1.776478,
      2,
      1,
      1.816468,
      0,
      0.896594,
      0,
      1,
      3.897534,
      2.900385,
      5.504068,
      8.900738,
      NULL,
      7.179510,
      5.720291,
      0,
      1,
      NULL,
      0.392164,
      3,
      0,
      0.276871,
      0.725287,
      1.197364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.239530,
      1.625008,
      NULL,
      1,
      0.326870,
      0.978482,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.371107,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      3.954380,
      0.787371,
      NULL,
      4.574920,
      1.201531,
      2,
      1.825364,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.679964,
      1,
      3.968265,
      0.538540,
      0,
      1,
      1,
      1,
      3,
      NULL,
      0.786525,
      0,
      0.865679,
      NULL,
      NULL,
      0,
      NULL,
      0.315715,
      NULL,
      NULL,
      NULL,
      0.495139,
      0.984452,
      0.221854,
      3,
      3,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1.547858,
      0.549685,
      0.975150,
      0,
      1.045013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.744802,
      NULL,
      '32242',
      NULL,
      0.736154,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      5,
      4.852351,
      2.596235,
      2,
      3.300542,
      NULL,
      1,
      3.458163,
      0.743882);
commit;
end;
/


