set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0343',
      '10103334',
      77.337524,
      32,
      '1111223',
      20.138031,
      6,
      2,
      0,
      '343040',
      NULL,
      ' 8-12-2000',
      40.483242,
      NULL,
      0.144431,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      2.667331,
      0.507020,
      1,
      0.048080,
      0.760255,
      11,
      1.696544,
      NULL,
      1,
      0.324788,
      2.828914,
      3.717512,
      1,
      NULL,
      1.254061,
      3,
      3,
      10,
      1,
      2,
      1,
      NULL,
      1.148190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.055254,
      0,
      NULL,
      1,
      0,
      1,
      2.324457,
      NULL,
      2.418244,
      2,
      0,
      1,
      3.033459,
      NULL,
      1,
      0.437028,
      0.359228,
      0,
      7,
      1.771042,
      0.793184,
      9.762672,
      1,
      0,
      0.850836,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.017227,
      NULL,
      1,
      0.313769,
      NULL,
      1,
      1.972321,
      0.253098,
      1.472293,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      4.791750,
      NULL,
      2,
      4,
      0,
      0.840934,
      3.678300,
      0,
      0.939210,
      4,
      0,
      NULL,
      5,
      9.496330,
      2,
      5.200351,
      NULL,
      0.687741,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.006180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0.744305,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953619,
      2,
      2.504939,
      2,
      1,
      NULL,
      NULL,
      1.841495,
      0.710425,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.024488,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143683,
      NULL,
      NULL,
      NULL,
      3.111377,
      1,
      1.619063,
      1.235429,
      0,
      NULL,
      1.551525,
      NULL,
      2,
      NULL,
      NULL,
      0.151378,
      0,
      NULL,
      1,
      3.908309,
      1.843592,
      NULL,
      1.564621,
      NULL,
      NULL,
      3,
      0.625722,
      0,
      NULL,
      0.930110,
      1.252023,
      NULL,
      1,
      1.740615,
      1.597812,
      0.146126,
      0.137507,
      1,
      1.624040,
      0.352969,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '21343',
      '',
      0.512646,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      2.416033,
      NULL,
      0,
      1,
      2.784121,
      1.385333);
commit;
end;
/


