set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0034',
      '02030010',
      65.484581,
      46.540572,
      '0300330',
      181,
      2,
      2.789815,
      2,
      '122043',
      3,
      ' 0- 8-1996',
      NULL,
      5.050678,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.300901,
      1,
      NULL,
      1,
      1.663436,
      0.524981,
      1,
      1.255136,
      1.081253,
      1,
      1,
      0.065485,
      5.305798,
      NULL,
      10,
      NULL,
      NULL,
      1.426612,
      1.447575,
      6.418643,
      0,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      1.857842,
      NULL,
      NULL,
      1.282532,
      3,
      2,
      2,
      1.941802,
      1,
      0,
      2,
      1,
      0,
      3.835351,
      1.492362,
      NULL,
      3,
      1,
      0.850102,
      1,
      1.741969,
      1.031113,
      3,
      0.881592,
      0,
      1.706734,
      0,
      1,
      1,
      0.713707,
      NULL,
      NULL,
      0.429139,
      NULL,
      NULL,
      1,
      0.599647,
      2.625462,
      0.595345,
      4,
      1.462758,
      1.280595,
      1.058379,
      1,
      0.954220,
      1,
      1,
      0,
      0,
      0.690152,
      1,
      1.992766,
      0,
      1.156304,
      NULL,
      1,
      0.602747,
      0.271300,
      NULL,
      0.998563,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416270,
      1,
      2,
      0.176608,
      1,
      0.389736,
      1,
      4,
      4.037681,
      2,
      5,
      0.471697,
      NULL,
      0.972802,
      NULL,
      0,
      0,
      1,
      1.111659,
      0,
      0.011098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425009,
      1.644308,
      0,
      1,
      1,
      0.992864,
      1,
      1.403344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.255552,
      2,
      NULL,
      1.977483,
      2.744071,
      NULL,
      7,
      0.159385,
      0.276791,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2.878276,
      2.251972,
      0,
      NULL,
      0,
      0,
      3.957172,
      1,
      1,
      2.227271,
      0.968246,
      1.243497,
      0.790817,
      NULL,
      1.257375,
      1.333608,
      1.103165,
      0.866274,
      0,
      1,
      NULL,
      0.119866,
      0.732250,
      0.562172,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.040060,
      0.640022,
      0,
      1,
      0.007844,
      0.967214,
      0.852546,
      1.371845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '20404',
      '40204',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      1.962576,
      0,
      NULL,
      1,
      1.662474,
      0,
      2.166364,
      NULL);
commit;
end;
/


