set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0424',
      '02314034',
      51,
      NULL,
      NULL,
      17.941901,
      NULL,
      0.559001,
      1,
      '242244',
      2.684601,
      NULL,
      31,
      55.814239,
      1,
      NULL,
      NULL,
      0,
      1,
      0.877274,
      0,
      NULL,
      NULL,
      1.339876,
      1,
      1,
      1.393585,
      1.928927,
      NULL,
      0,
      1.021934,
      5.477852,
      2.362958,
      11.547482,
      0.891062,
      1.749140,
      NULL,
      0.195003,
      11,
      0,
      NULL,
      3,
      1,
      0.252124,
      NULL,
      NULL,
      1.150376,
      NULL,
      NULL,
      8,
      NULL,
      1,
      1.719153,
      NULL,
      NULL,
      NULL,
      0,
      0.453396,
      2.115370,
      NULL,
      1.627981,
      1,
      NULL,
      NULL,
      0.950968,
      2,
      NULL,
      0,
      9.691604,
      0.149622,
      0,
      2.789603,
      NULL,
      NULL,
      1,
      1.242470,
      NULL,
      NULL,
      0.876772,
      NULL,
      NULL,
      1.372536,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437633,
      0.103623,
      NULL,
      0,
      0.880258,
      0,
      0,
      NULL,
      0,
      NULL,
      1.762780,
      0,
      1.342142,
      1,
      NULL,
      1,
      NULL,
      0.906596,
      NULL,
      0,
      1.856490,
      0.098960,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.474292,
      1,
      NULL,
      0.346197,
      4,
      NULL,
      NULL,
      1.379114,
      4,
      11,
      0.945140,
      0,
      0,
      NULL,
      3.058613,
      NULL,
      0.673227,
      1.242735,
      0.845282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.702426,
      0,
      0,
      1.226891,
      1,
      1,
      1.820406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.585943,
      NULL,
      NULL,
      3.424587,
      1,
      1.680568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.712324,
      NULL,
      2,
      NULL,
      1.351981,
      0.596836,
      1,
      1.768523,
      6,
      0,
      0.712837,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.202126,
      2,
      1.943463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.604399,
      1,
      0.880666,
      NULL,
      1.624155,
      2.036921,
      1.788596,
      1,
      NULL,
      1,
      0.305663,
      NULL,
      1.989985,
      0,
      0,
      1.203251,
      1.498876,
      NULL,
      1,
      1.236242,
      0.997252,
      NULL,
      0,
      2,
      2,
      3,
      1,
      0,
      0.182422,
      NULL,
      1.736416,
      1.716481,
      1,
      1.104000,
      1,
      0.676966,
      0,
      1.234495,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575341,
      '10120',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      0.883618,
      '',
      '',
      '',
      3,
      3.984657,
      3.467572,
      5,
      1.196717,
      1,
      0,
      2.650703,
      NULL);
commit;
end;
/


