set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1033',
      NULL,
      34.741602,
      NULL,
      '0031340',
      170,
      0,
      2,
      3,
      '143301',
      5,
      ' 1-20-1988',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.496283,
      1.928569,
      0.378652,
      0.440007,
      NULL,
      0,
      1,
      1.948778,
      NULL,
      1,
      2,
      NULL,
      NULL,
      5,
      1.113556,
      1,
      1,
      2,
      1,
      0,
      3.769019,
      0.697828,
      0,
      NULL,
      NULL,
      0.776375,
      NULL,
      NULL,
      5.297935,
      NULL,
      0,
      1.323638,
      NULL,
      1.287324,
      0,
      NULL,
      1,
      2,
      3.288277,
      NULL,
      0.730056,
      NULL,
      0,
      0.512569,
      3,
      NULL,
      NULL,
      2.375908,
      0,
      0,
      8.083881,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.450059,
      1,
      NULL,
      4,
      1,
      0,
      0.124521,
      NULL,
      1.390528,
      1,
      1,
      1.128513,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1.766921,
      1,
      0,
      0.214975,
      1,
      0.594052,
      1.174586,
      1,
      NULL,
      2.309634,
      NULL,
      4,
      0.954792,
      0.535265,
      4,
      0.553305,
      0,
      2,
      0.552868,
      1,
      5,
      6.079584,
      6,
      5,
      6.257598,
      1.005704,
      0,
      0.575687,
      NULL,
      1.458371,
      1.885226,
      1.041123,
      0.951272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.473273,
      0.717124,
      0.745879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703511,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820407,
      NULL,
      0.392841,
      3,
      0.844733,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973409,
      5,
      0.397713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.673916,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      1,
      0.188616,
      0.636231,
      1,
      0,
      1.400461,
      1.681320,
      NULL,
      0.311044,
      NULL,
      NULL,
      1.989050,
      1,
      0,
      1,
      0.019966,
      0,
      0.261578,
      2,
      0,
      1.789038,
      NULL,
      1,
      1.889542,
      NULL,
      0.528092,
      NULL,
      1,
      0,
      NULL,
      0.953557,
      1,
      1.321507,
      1.698965,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.020500,
      1,
      0,
      1.282582,
      '03140',
      '22021',
      '',
      0.464599,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.523285,
      NULL,
      0.815018,
      4,
      2,
      3.028342,
      3.229984,
      2.812362,
      2.388491);
commit;
end;
/


