set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9510460';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '44',
      NULL,
      19.426288,
      '4443431',
      13,
      NULL,
      NULL,
      0,
      '243013',
      3,
      ' 5-29-1999',
      116.831407,
      NULL,
      1,
      NULL,
      0.970761,
      0,
      3.623064,
      0,
      0,
      1.654039,
      2.254663,
      1,
      1,
      1.135848,
      0.513144,
      0,
      1.261468,
      0.250142,
      0,
      1,
      2,
      NULL,
      1.354623,
      1,
      1.980396,
      1,
      1.533237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.404966,
      1,
      2,
      1,
      3,
      0.875489,
      0.233679,
      1,
      0,
      1,
      NULL,
      1.195980,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.208506,
      NULL,
      NULL,
      0,
      1.735530,
      NULL,
      1,
      0,
      1,
      1,
      0.017444,
      0,
      0,
      1.765097,
      0.322975,
      1,
      1.223678,
      0,
      1.941623,
      0.833162,
      1.498607,
      NULL,
      NULL,
      NULL,
      2.509876,
      5.528037,
      NULL,
      1.211447,
      0.420095,
      0.581121,
      NULL,
      0.682608,
      1.024027,
      1.025328,
      NULL,
      0.773527,
      1.381947,
      3,
      NULL,
      NULL,
      1,
      1.670587,
      5.627543,
      1,
      0,
      5.201424,
      NULL,
      6,
      0,
      0,
      2.813400,
      0,
      NULL,
      NULL,
      NULL,
      0.531229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313531,
      0.265940,
      1,
      NULL,
      0.970455,
      0,
      0.779922,
      1.075524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941918,
      NULL,
      NULL,
      0.825163,
      1.086426,
      NULL,
      1.964522,
      NULL,
      NULL,
      NULL,
      1.627563,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      3,
      1.261212,
      NULL,
      1.340622,
      3.050432,
      1,
      0.418805,
      0,
      0.432055,
      0.843309,
      0,
      1.220583,
      NULL,
      NULL,
      1.357070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '43011',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      1.853277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


