set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9510460';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      '13',
      46,
      9,
      '1224342',
      25.169248,
      5,
      1.809446,
      1,
      '321432',
      2,
      NULL,
      72.036214,
      44.702391,
      0.390710,
      NULL,
      0,
      1,
      1,
      1.053208,
      1,
      NULL,
      0,
      1.413949,
      2,
      1.225326,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0.284320,
      1,
      0.988914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.641400,
      1.670891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.391172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.084400,
      0.491257,
      1.107948,
      NULL,
      1.223840,
      0,
      NULL,
      NULL,
      1.582283,
      1,
      1.821895,
      1.629076,
      0,
      1,
      1.506181,
      1,
      NULL,
      1.840129,
      1.093192,
      NULL,
      1,
      0.854344,
      4.456380,
      NULL,
      0.081714,
      0.451669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.400919,
      1,
      5,
      1.072374,
      1,
      3,
      NULL,
      2.084825,
      0,
      4.116581,
      1.994174,
      0.247493,
      0.246152,
      1,
      NULL,
      NULL,
      NULL,
      1.957707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873391,
      0,
      1,
      1,
      1.336178,
      1.933095,
      1.668211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739587,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428766,
      0.244270,
      0,
      1.821040,
      1.489763,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.256763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292802,
      0,
      0.609164,
      0,
      0.340228,
      1,
      0.899918,
      0,
      NULL,
      3.193497,
      0,
      0.431776,
      1.958089,
      1.290979,
      1,
      1.776485,
      0,
      0,
      1.708496,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.727675,
      '10122',
      '',
      NULL,
      1.813666,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      3.066753,
      2.306182,
      NULL,
      NULL,
      2.119511,
      NULL,
      0,
      3,
      2);
commit;
end;
/


