set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '230',
      '34',
      45.537848,
      17,
      '4243234',
      19.015819,
      3,
      0,
      3,
      '332230',
      NULL,
      ' 0-10-1982',
      78.885316,
      43.775722,
      1,
      NULL,
      2.419184,
      3,
      NULL,
      0,
      1.471190,
      2.179941,
      1,
      0,
      0.284115,
      1.615060,
      0,
      0,
      1,
      1.800999,
      0.338960,
      0,
      1,
      4,
      3.056943,
      1,
      7.807652,
      0,
      5,
      0,
      3,
      3.718071,
      NULL,
      1.619809,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      4.689942,
      2,
      1.172594,
      1.694098,
      1.542532,
      2,
      1.230870,
      1,
      1,
      NULL,
      3,
      3.483798,
      2.721809,
      3.421655,
      1.515035,
      3,
      3.726903,
      2,
      2.981161,
      1.982399,
      1,
      1,
      2,
      1.934800,
      0.838029,
      NULL,
      NULL,
      0.370232,
      NULL,
      NULL,
      1,
      NULL,
      3.494898,
      0,
      0,
      NULL,
      1.900669,
      0.089329,
      1,
      NULL,
      NULL,
      1.377214,
      1.851249,
      0,
      NULL,
      0,
      1,
      0.635296,
      1.780435,
      NULL,
      1,
      6.538954,
      1.570701,
      1.427999,
      NULL,
      1,
      3.366505,
      NULL,
      3.997179,
      5.966744,
      4,
      NULL,
      NULL,
      1.273428,
      0,
      5.325690,
      0.353848,
      2.696396,
      NULL,
      4,
      0.278415,
      7.542686,
      NULL,
      4.780783,
      5,
      2,
      3.044571,
      NULL,
      3,
      1,
      1.672214,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.456546,
      NULL,
      2,
      2,
      1.326109,
      NULL,
      1.960616,
      1.182835,
      1.319692,
      2.289990,
      4,
      8,
      0.688623,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      1.891142,
      0,
      2.235986,
      NULL,
      NULL,
      NULL,
      0.057276,
      0,
      0.805910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.482761,
      2,
      2,
      2.058012,
      2.278109,
      NULL,
      1,
      NULL,
      0.807380,
      NULL,
      1,
      0.041876,
      0.719516,
      1.551767,
      1.541348,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '40212',
      '',
      '',
      0.392115,
      '',
      '',
      '',
      NULL,
      '140',
      '2424',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


