set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12',
      29,
      6,
      '2443104',
      4.721908,
      0,
      1.011456,
      2,
      '103420',
      2,
      ' 5-10-1987',
      NULL,
      18.685141,
      1,
      NULL,
      4.681413,
      1,
      0,
      0.104852,
      1,
      0,
      NULL,
      0.552505,
      0.725808,
      1,
      7.560461,
      NULL,
      1.389319,
      1.986931,
      NULL,
      1,
      5.458614,
      1.626401,
      5,
      0,
      0,
      1,
      5.271427,
      NULL,
      3.715815,
      0.232079,
      1.730448,
      0,
      NULL,
      NULL,
      1.608684,
      NULL,
      NULL,
      1.553999,
      1,
      1.763498,
      0.629400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.153434,
      0,
      2.716962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612961,
      0.720056,
      0.107508,
      0.484909,
      1.937901,
      1.062135,
      1,
      0.678954,
      NULL,
      0.925439,
      1,
      0.783875,
      1.032359,
      2,
      0.494376,
      0.320407,
      1.284713,
      1,
      0.037093,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      6,
      3,
      NULL,
      2.955302,
      1.775397,
      3.600575,
      2.014985,
      0,
      0.258090,
      5.732725,
      0,
      NULL,
      6,
      2.557877,
      3,
      5.796819,
      3,
      NULL,
      1.356572,
      NULL,
      4.099123,
      NULL,
      0,
      NULL,
      1.967770,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.519829,
      1,
      0,
      1.300296,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674172,
      NULL,
      NULL,
      0.758738,
      NULL,
      3.705370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.550132,
      NULL,
      0.270781,
      NULL,
      NULL,
      NULL,
      0.073058,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.275360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988858,
      1,
      NULL,
      3,
      3.230176,
      0,
      NULL,
      NULL,
      0.867581,
      3.579855,
      2.575890,
      NULL,
      1.963920,
      1,
      1,
      NULL,
      1,
      0.004231,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.380007,
      '33310',
      '',
      '',
      1,
      '',
      '',
      NULL,
      3,
      '111',
      NULL,
      '',
      6.502630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


