set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '33203141',
      6.663205,
      47.314933,
      '2014043',
      NULL,
      1,
      1,
      3,
      '243014',
      0.639541,
      ' 7- 7-1983',
      73,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0.702196,
      0,
      1.968597,
      0.068509,
      3.325780,
      1.218034,
      1.654089,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594251,
      4,
      1,
      3.857150,
      0,
      1,
      0.874069,
      7.681322,
      NULL,
      4,
      2.079599,
      2,
      0.041741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.382799,
      1.723960,
      0,
      NULL,
      1.779380,
      0.285604,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.597105,
      1,
      NULL,
      1,
      1,
      2.413001,
      1.215634,
      0.414178,
      0,
      0,
      5,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.571492,
      1,
      0.181231,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0.618299,
      NULL,
      0.155885,
      3.159501,
      1.368379,
      NULL,
      1.841189,
      1.800689,
      0,
      NULL,
      1.108047,
      3,
      0,
      0.480562,
      NULL,
      1.829089,
      0,
      1.637863,
      1,
      0,
      1.270080,
      3,
      1,
      3,
      3.356693,
      3.753823,
      NULL,
      1,
      1,
      4,
      3.265901,
      NULL,
      NULL,
      4.980559,
      2,
      0.550255,
      NULL,
      NULL,
      2.334378,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      3,
      3.583366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.306539,
      NULL,
      1.223773,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.712755,
      3,
      5,
      0,
      0.194480,
      NULL,
      NULL,
      NULL,
      1.085783,
      5.344360,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442132,
      0,
      0,
      1,
      1.155274,
      0.829427,
      0.206394,
      0,
      0,
      1,
      1,
      NULL,
      1.176088,
      NULL,
      1,
      1.479913,
      1.624411,
      1,
      0,
      1.229040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.013913,
      '00024',
      '',
      NULL,
      0.335023,
      '',
      NULL,
      '',
      0,
      NULL,
      '1024',
      '',
      5.675770,
      NULL,
      3,
      1.319505,
      NULL,
      1,
      2.580350,
      1.720674,
      1.935848);
commit;
end;
/


