set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '040',
      '04441032',
      55.098293,
      24,
      '0111241',
      82,
      5,
      1,
      1,
      '023303',
      3,
      NULL,
      33.278994,
      237.644217,
      0,
      NULL,
      4,
      0,
      3.459299,
      0.733954,
      1,
      0,
      0.123286,
      3.625913,
      0,
      0.597486,
      8.061965,
      NULL,
      0,
      0,
      NULL,
      0,
      0.778366,
      0,
      1,
      NULL,
      2.498897,
      0.638350,
      5.910909,
      1,
      4.169103,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.513791,
      1,
      1,
      0.725851,
      1,
      3.945529,
      2.884969,
      0,
      NULL,
      3,
      NULL,
      0.900964,
      1,
      0.694033,
      NULL,
      1.119789,
      2.006823,
      3.531754,
      3,
      5,
      NULL,
      3.933288,
      7,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.714406,
      1.910307,
      0,
      1,
      0.924343,
      0,
      0.092927,
      1,
      1.808630,
      1.962603,
      1,
      1.008238,
      NULL,
      1,
      1.595154,
      1,
      1,
      0,
      NULL,
      NULL,
      5.761824,
      1.634956,
      1,
      NULL,
      0,
      0.817487,
      1,
      NULL,
      0,
      2.444142,
      3.087325,
      4,
      1.245351,
      2,
      2,
      5,
      5,
      7.276921,
      9.448692,
      4,
      8.946301,
      0,
      0.027450,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.967542,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.272140,
      NULL,
      1,
      1.774857,
      0,
      3.391018,
      0.444110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.916425,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596963,
      0.070886,
      3.964384,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930280,
      2.488139,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      0.504172,
      0,
      3,
      0.059065,
      0.325488,
      0.848092,
      1,
      0,
      0,
      0.289439,
      NULL,
      NULL,
      1.405117,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843072,
      '32311',
      '',
      '',
      1.895775,
      '',
      '',
      '',
      1.797920,
      '324',
      NULL,
      '',
      NULL,
      0,
      3.153322,
      5,
      NULL,
      2.126960,
      3,
      0.685260,
      2.443135);
commit;
end;
/


