set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      '01330322',
      57.409451,
      NULL,
      '4101344',
      69,
      4,
      NULL,
      1,
      '412402',
      NULL,
      ' 9-11-2000',
      99.429094,
      193,
      1.336698,
      NULL,
      1.191979,
      0.911002,
      3,
      1.291776,
      0.672386,
      NULL,
      0.451997,
      1,
      0.434912,
      1.485740,
      3.481015,
      NULL,
      1,
      1,
      1.455401,
      1.810854,
      2,
      0,
      5.797799,
      0,
      NULL,
      1,
      NULL,
      1,
      1.432078,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.430197,
      1,
      4.635696,
      0.402378,
      1,
      3.005022,
      NULL,
      0.463937,
      0,
      0,
      NULL,
      0.660014,
      0.550928,
      1.314183,
      NULL,
      0,
      1.923232,
      0,
      2,
      NULL,
      4.268962,
      7,
      NULL,
      NULL,
      2,
      4.003009,
      1.973494,
      NULL,
      NULL,
      1.702672,
      NULL,
      NULL,
      NULL,
      0.365378,
      1.515583,
      NULL,
      2,
      0.674921,
      1,
      NULL,
      0.489566,
      0.854021,
      0.775778,
      1,
      1,
      2.361991,
      NULL,
      1,
      1.048493,
      NULL,
      1,
      NULL,
      0.245845,
      7.360963,
      NULL,
      0.300948,
      6.134143,
      NULL,
      3.606516,
      0,
      NULL,
      NULL,
      0,
      0.465535,
      4,
      1.735157,
      7.473301,
      0,
      2.962162,
      3,
      0,
      2,
      NULL,
      4,
      3,
      5.732586,
      NULL,
      1.644146,
      1.612898,
      NULL,
      1.453719,
      NULL,
      1.671129,
      NULL,
      1.250184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      2,
      1.199976,
      0.033699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.153348,
      0,
      4.408824,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      7.094210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.703979,
      2,
      NULL,
      3.147269,
      2,
      3,
      1,
      3,
      3,
      0,
      0.605673,
      1,
      1.734926,
      1,
      1,
      0.624534,
      0.090458,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '14200',
      '',
      '',
      1.417907,
      '',
      '',
      NULL,
      4,
      '001',
      '0014',
      '',
      3.831221,
      1.185896,
      3,
      NULL,
      NULL,
      3.146034,
      1,
      3.040515,
      3);
commit;
end;
/


