set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '22104132',
      NULL,
      54,
      '4232304',
      25,
      1,
      3,
      2,
      '204434',
      0.544796,
      ' 3-11-1992',
      120.987044,
      32.874035,
      0.087767,
      NULL,
      4,
      0.200597,
      NULL,
      NULL,
      1.520813,
      1.278959,
      1,
      0,
      1.128685,
      1.577861,
      0,
      0.011147,
      NULL,
      1,
      0,
      1,
      3.849729,
      0.521209,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.176656,
      0.218209,
      2,
      3.184121,
      0.384328,
      NULL,
      3,
      NULL,
      1,
      0.372455,
      2,
      1,
      0,
      0,
      0.401795,
      NULL,
      3,
      0.748277,
      3,
      NULL,
      1.368093,
      2,
      6.836068,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.348756,
      NULL,
      0,
      1.632154,
      0.370446,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.462079,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.629773,
      4,
      0,
      1.953733,
      NULL,
      1,
      4.617473,
      1,
      1.474901,
      1.142486,
      2,
      2,
      3.784807,
      1,
      NULL,
      1,
      2.010011,
      NULL,
      NULL,
      6,
      1.865982,
      2,
      8.447811,
      3.247265,
      0,
      2,
      0.983655,
      2,
      NULL,
      0.827613,
      1,
      2.941721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.543955,
      NULL,
      NULL,
      1.056507,
      2.749905,
      0.099983,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.253334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.278345,
      3.016230,
      3,
      4,
      0,
      0.574542,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.442724,
      3.950335,
      NULL,
      0,
      3,
      3.926799,
      1.529259,
      NULL,
      1.677034,
      0,
      1,
      1.280803,
      NULL,
      0.957439,
      NULL,
      NULL,
      1.527921,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.432443,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '131',
      '3324',
      '',
      5.102964,
      1,
      0.140356,
      1,
      NULL,
      3,
      3.998281,
      2.322898,
      2.830381);
commit;
end;
/


