set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '310',
      '33440030',
      49,
      39.875814,
      '1411031',
      104,
      0,
      NULL,
      NULL,
      '404041',
      5.299088,
      NULL,
      NULL,
      13,
      0.027971,
      NULL,
      5.182627,
      1.381790,
      0,
      NULL,
      0.794161,
      2.885524,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.425105,
      0.371533,
      0,
      NULL,
      1.695045,
      2,
      1,
      2.263282,
      0,
      1.370883,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.721679,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.311858,
      2.638654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0.220678,
      0,
      0,
      1.639284,
      0,
      0.585313,
      NULL,
      NULL,
      0.214752,
      0.840656,
      0,
      1,
      NULL,
      NULL,
      0.193267,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1.414949,
      1.841019,
      1,
      0,
      4,
      1,
      3.847190,
      1,
      1,
      2.050396,
      3.482847,
      3,
      6,
      2,
      0.913827,
      NULL,
      8.274758,
      4.204562,
      4.201939,
      6,
      9.115104,
      NULL,
      1.549566,
      NULL,
      1,
      NULL,
      NULL,
      6.557267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779527,
      1.658918,
      1,
      NULL,
      1,
      3.893192,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.371314,
      NULL,
      NULL,
      NULL,
      NULL,
      2.572478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.992267,
      2.484174,
      0,
      2,
      0.443315,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921424,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.662217,
      NULL,
      0.797138,
      1.420056,
      2,
      1,
      0,
      0.773777,
      0,
      3.095837,
      1,
      1.224414,
      0,
      1,
      1.666564,
      1.132613,
      0.097985,
      1.477955,
      1,
      0.523441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.756382,
      '03434',
      '',
      '',
      1.006395,
      '',
      '',
      '',
      1,
      '030',
      '4011',
      '',
      4,
      NULL,
      NULL,
      3.396621,
      0.963020,
      3.268119,
      1,
      2.692231,
      2.473949);
commit;
end;
/


