set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132691';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '13',
      17.665876,
      14,
      '2134413',
      9,
      0,
      3,
      2,
      '342324',
      4,
      NULL,
      30.793659,
      0.694348,
      1.350693,
      NULL,
      NULL,
      NULL,
      1.959021,
      0.687866,
      NULL,
      1,
      NULL,
      0.093170,
      1,
      0,
      5,
      0,
      2,
      0.746199,
      1,
      0.382818,
      2,
      0,
      2.436141,
      1.128075,
      1,
      1.327165,
      1,
      0,
      0,
      0.302227,
      2,
      0.156546,
      NULL,
      NULL,
      0.263169,
      NULL,
      NULL,
      0.322509,
      1.706337,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241791,
      NULL,
      1,
      2,
      1.245651,
      0,
      NULL,
      NULL,
      0.152254,
      NULL,
      NULL,
      1.077531,
      NULL,
      0.251328,
      NULL,
      0.757165,
      NULL,
      0.860023,
      1.601038,
      1,
      0,
      1.358734,
      1.813070,
      0.189047,
      NULL,
      0.839873,
      0,
      0,
      1.298266,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.723901,
      1,
      1,
      0,
      NULL,
      1.773884,
      1.715249,
      0,
      0.925478,
      1.674376,
      6,
      1,
      1,
      8,
      NULL,
      4.207937,
      5,
      3.784424,
      5,
      7,
      5.641186,
      0.550848,
      2.993365,
      2.643987,
      3,
      0.322630,
      0.373518,
      1.202616,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018606,
      NULL,
      0,
      1,
      0.873114,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.349598,
      NULL,
      1.369772,
      3.313737,
      NULL,
      3,
      1.722211,
      0,
      0.138659,
      1.664153,
      3,
      2.036085,
      3,
      0,
      NULL,
      NULL,
      NULL,
      5.128426,
      1.583803,
      NULL,
      0.892473,
      0,
      2,
      0.177295,
      NULL,
      NULL,
      NULL,
      1.394277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518638,
      2.108397,
      NULL,
      1,
      3.358327,
      1.359163,
      0,
      1.807361,
      0.644835,
      1,
      1,
      0,
      0.238776,
      0,
      NULL,
      NULL,
      0.648732,
      0,
      1.249007,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '12021',
      '',
      '',
      0.654681,
      '',
      '',
      '',
      3,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


