set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132691';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '103',
      NULL,
      33,
      15,
      NULL,
      4.868870,
      2,
      2,
      1,
      '222143',
      NULL,
      ' 9- 3-2003',
      34.469434,
      0,
      NULL,
      NULL,
      1,
      0.661296,
      0.241998,
      0,
      0.403172,
      1.410831,
      NULL,
      0.700311,
      NULL,
      1.148842,
      NULL,
      0,
      0.687432,
      NULL,
      0.344252,
      0.446990,
      4,
      4,
      1,
      0.881443,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      2.424014,
      1.843285,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.977692,
      1.630922,
      NULL,
      0.119011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.374980,
      NULL,
      1.519220,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.789838,
      1.430476,
      0.402874,
      0.886813,
      1,
      1,
      0.094961,
      0,
      0,
      1.178496,
      1,
      NULL,
      1,
      1.639586,
      0,
      1,
      0.531667,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      NULL,
      3,
      1,
      NULL,
      1.216472,
      NULL,
      2,
      2.499205,
      NULL,
      2,
      0.780530,
      4,
      0.994718,
      9,
      4,
      4.559308,
      1.729869,
      2,
      1.433518,
      9.622891,
      2,
      1,
      2.174890,
      1.604194,
      0.261469,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700685,
      NULL,
      2,
      1,
      0,
      0.420208,
      0.752684,
      1.814614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.321458,
      NULL,
      1.561776,
      NULL,
      3.939198,
      0.860690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.555073,
      2.343769,
      1.482628,
      NULL,
      NULL,
      NULL,
      1.863457,
      NULL,
      5,
      3.510612,
      4,
      NULL,
      1.075728,
      NULL,
      NULL,
      NULL,
      1.766078,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.033650,
      2,
      NULL,
      3,
      1,
      3.774573,
      NULL,
      NULL,
      2.286554,
      NULL,
      1.022991,
      0,
      0,
      0.271056,
      0,
      1,
      NULL,
      0.919963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.949676,
      '24042',
      '',
      '',
      1.061772,
      '',
      NULL,
      NULL,
      NULL,
      '4131',
      '',
      '',
      5.025852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


