set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132691';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31',
      NULL,
      18,
      NULL,
      7,
      NULL,
      3,
      NULL,
      '111031',
      5,
      ' 9-12-1998',
      20,
      14,
      0.389938,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      3.986516,
      1,
      0.276846,
      0,
      6.775642,
      1.627258,
      0,
      6.611762,
      NULL,
      0.824268,
      0.071854,
      NULL,
      1,
      1,
      NULL,
      0.760908,
      5,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.148706,
      3.880286,
      2.509264,
      NULL,
      0.288530,
      NULL,
      NULL,
      2.689247,
      1.799890,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.110481,
      NULL,
      1,
      0,
      1.975231,
      1.308775,
      1,
      1.081117,
      7,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.113201,
      1,
      3.574173,
      1,
      2,
      0,
      NULL,
      0,
      1.779268,
      1.673652,
      NULL,
      1,
      0.085104,
      0.975868,
      1.388623,
      1.891397,
      0.855701,
      NULL,
      1,
      NULL,
      0,
      3,
      3.462659,
      0,
      2.409592,
      0,
      0,
      0.317421,
      0.602373,
      NULL,
      5,
      NULL,
      4.728324,
      1.885365,
      NULL,
      0.465050,
      2.680909,
      6,
      3.556471,
      5.310625,
      2.792103,
      2,
      0,
      3,
      NULL,
      2.589475,
      NULL,
      0.141172,
      0.657908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0.505231,
      0,
      0.798085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0.238087,
      1.108121,
      0,
      NULL,
      3.378170,
      3.593656,
      6.977121,
      9.339379,
      3.824940,
      1.166049,
      NULL,
      NULL,
      NULL,
      NULL,
      5.465185,
      9,
      1,
      0.316232,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875312,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674056,
      0.990932,
      0.428985,
      0.904393,
      NULL,
      1.948215,
      0,
      2.416749,
      NULL,
      0.907362,
      2.863631,
      0.401893,
      1.328605,
      0,
      0,
      NULL,
      0,
      0.173048,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.611280,
      '11410',
      '',
      '',
      0.048139,
      '',
      '',
      '',
      3.916187,
      '2010',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


