set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132691';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '021',
      '3',
      NULL,
      NULL,
      '0400202',
      16,
      6,
      0,
      1,
      NULL,
      NULL,
      '11-12-1980',
      22.313349,
      59.757434,
      1.395989,
      NULL,
      NULL,
      1.607700,
      1.583772,
      0,
      0,
      0.966788,
      0,
      NULL,
      0,
      1.359417,
      1.205863,
      1,
      NULL,
      0,
      1.810404,
      1.577987,
      NULL,
      1.327391,
      1.887248,
      1,
      0.670360,
      0.028682,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001306,
      1.746765,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.180132,
      NULL,
      0.278216,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634148,
      1.286926,
      1.686237,
      1,
      1.448071,
      0.411729,
      NULL,
      0,
      0,
      NULL,
      0.499229,
      NULL,
      1,
      0.272870,
      1,
      0,
      0.984075,
      1.363232,
      NULL,
      NULL,
      1,
      0.638892,
      1,
      NULL,
      1.700298,
      1.910230,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.871756,
      NULL,
      0.710293,
      3,
      7,
      NULL,
      2.865545,
      3.083837,
      1.260144,
      4,
      0.499678,
      2.128781,
      4,
      3.205624,
      3.927672,
      NULL,
      NULL,
      NULL,
      3.043287,
      0.029671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.491370,
      1,
      1,
      1.242875,
      NULL,
      0,
      0.334170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122633,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.824963,
      0.695001,
      NULL,
      NULL,
      NULL,
      1,
      3.610119,
      0,
      2,
      1.974420,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.159213,
      2.682023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.377232,
      0,
      0,
      1,
      0,
      1.830947,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '01012',
      NULL,
      '',
      1.654374,
      '',
      '',
      NULL,
      1.299691,
      '1032',
      NULL,
      '',
      2.104410,
      4.735715,
      2,
      2,
      3.904420,
      1,
      0.238266,
      1,
      1);
commit;
end;
/


