set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132691';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '441',
      '14241143',
      NULL,
      52.189460,
      NULL,
      97,
      NULL,
      1.378918,
      1,
      '334032',
      2,
      ' 8- 0-1985',
      9,
      32,
      1,
      NULL,
      NULL,
      NULL,
      1.848303,
      NULL,
      NULL,
      1,
      0.637852,
      0.343080,
      0,
      0.056205,
      1,
      0,
      1.362022,
      NULL,
      NULL,
      1,
      0.277888,
      1,
      0,
      NULL,
      1,
      0.367067,
      1.386608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830421,
      0,
      1.349906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.637352,
      0,
      0.866931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698426,
      1.947182,
      1,
      1.534287,
      0.511577,
      NULL,
      0.885091,
      1,
      1.422410,
      0.987941,
      0.445035,
      NULL,
      0.988226,
      1,
      1.633792,
      1.227861,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      3.498116,
      1.576953,
      2.521783,
      1.915028,
      1,
      3,
      0,
      6.781603,
      3.995359,
      NULL,
      2.467877,
      4.117200,
      1.218948,
      5.156011,
      NULL,
      8,
      7,
      2,
      5.113490,
      8.050750,
      0,
      0,
      NULL,
      2,
      1.445127,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0.902933,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1.952309,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.231323,
      6,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.330250,
      NULL,
      0.833349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736441,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.811093,
      2,
      1.346977,
      0.646762,
      0.287976,
      0,
      NULL,
      NULL,
      0.746222,
      1,
      0,
      NULL,
      0,
      0.081176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '40242',
      '',
      '',
      1.791166,
      '',
      '',
      '',
      0.059869,
      NULL,
      '',
      '',
      1.240643,
      1,
      3,
      NULL,
      NULL,
      1.615260,
      0.331530,
      3.027299,
      2.232565);
commit;
end;
/


