set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132691';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01013211',
      21,
      74.972564,
      '3432120',
      135.243308,
      4,
      2.804362,
      1,
      '424210',
      1,
      ' 4-16-1993',
      21.006332,
      NULL,
      0.651713,
      NULL,
      0,
      1,
      1.502337,
      1.331353,
      NULL,
      3,
      0.041485,
      1.708240,
      3,
      0,
      1,
      1.872381,
      1,
      2.481762,
      1,
      0.497305,
      1,
      0.512453,
      NULL,
      0,
      0,
      1,
      0.297266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659610,
      1.231138,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333413,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611386,
      3.625556,
      1.625882,
      NULL,
      1.649641,
      0,
      NULL,
      NULL,
      1,
      2.002455,
      1,
      1,
      0,
      NULL,
      1.407624,
      1,
      1,
      0.554191,
      1.560563,
      NULL,
      1.997216,
      7,
      0.625016,
      0.083500,
      1,
      1.411781,
      2,
      NULL,
      2.099018,
      NULL,
      3,
      7.921126,
      NULL,
      0.408633,
      0,
      5,
      6.390467,
      NULL,
      NULL,
      3.692393,
      NULL,
      0.458486,
      7,
      NULL,
      1,
      0,
      1,
      0.350865,
      NULL,
      NULL,
      NULL,
      5.577768,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477696,
      0,
      0,
      1,
      1.287955,
      NULL,
      1.631790,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.162609,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.459848,
      0,
      NULL,
      NULL,
      NULL,
      5,
      5,
      3.504523,
      5,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.991504,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      0,
      0.321535,
      2,
      1,
      1.740806,
      NULL,
      1,
      NULL,
      1.839981,
      1,
      0.171773,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.219686,
      '',
      NULL,
      '',
      NULL,
      NULL,
      3,
      3,
      2.786821,
      1,
      2.033066,
      3,
      3);
commit;
end;
/


