set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7224559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '102',
      NULL,
      34,
      29,
      '3102032',
      87.477837,
      0,
      NULL,
      NULL,
      NULL,
      3,
      '11-24-1986',
      13,
      38.863317,
      1.475801,
      NULL,
      NULL,
      1,
      1,
      0,
      0.687863,
      1.737667,
      NULL,
      1.197923,
      0,
      0,
      0,
      NULL,
      0.655603,
      1,
      NULL,
      0,
      1,
      1,
      1.274285,
      1,
      1.973562,
      1.915667,
      0,
      1,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.860324,
      NULL,
      NULL,
      NULL,
      1,
      0.175791,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.992324,
      0.158882,
      4.853277,
      6,
      NULL,
      0.595259,
      0,
      0.518729,
      3.225981,
      2.979541,
      NULL,
      4,
      1,
      NULL,
      1.603738,
      1.484176,
      1.416006,
      NULL,
      1.603430,
      NULL,
      4.128187,
      1.007414,
      0.296899,
      1,
      7.056478,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.330681,
      1.852156,
      NULL,
      4,
      6.810720,
      0.121130,
      NULL,
      4.655423,
      NULL,
      5.769801,
      2,
      3.481617,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      5.754687,
      1.895639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1.625819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.062079,
      0,
      1.234739,
      NULL,
      0.717383,
      NULL,
      NULL,
      NULL,
      1.667414,
      NULL,
      NULL,
      NULL,
      1,
      0.745963,
      NULL,
      3.914718,
      0.845142,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.726765,
      0.695611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827645,
      0,
      1,
      0,
      0,
      2.076998,
      0,
      0,
      0,
      1.929014,
      NULL,
      1,
      1.391737,
      NULL,
      1.734920,
      1,
      0,
      1.826723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837285,
      '32011',
      NULL,
      NULL,
      0.023431,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      2,
      0.954265,
      2,
      0.744578,
      3.602758,
      0.481139,
      2,
      NULL);
commit;
end;
/


